
local image = require("Image")
local screen = require("Screen")
local event = require("Event")

local source = image.fromString([[402A000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⣄000B00⢤001600⣤281700⣤001700⣤281C00⣤004C00⣤284D00⣤004C00⣤004700⣤001C00⣤004700⣤284C00⣤057800⣤287700⣤287700⣤004700⣤287800⣤004C00⣤065200⡤287700⣤287700⣤284D00⣤287700⣤285200⣤057700⣤284C00⣤284700⣤004700⣤284C00⣤284700⣤004700⣤281C00⣤001700⣤004700⣤001700⣤001700⣤001700⣤001600⣤000600⠄000000⠀002800⡀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⢀002800⢂000600⡐061C00⢂0B2100⣒002200⠒282200⠒281C00⠗281C00⠖281C00⠗282100⠲287D00⠚287D00⠒287D00⠚28A900⠒284D00⠒282100⠛062200⠒285200⠒285200⠒065200⠒285200⠒06A900⠒28A900⠓067D00⠚285200⠒287D00⠒067D00⠒287D00⠒285200⠒055200⠒282200⠒285200⠒282200⠒282200⠒282100⠚285200⠒285200⠒005200⠒0B5200⢒061C00⣒001000⣊000600⠂002800⢐000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠002800⠠000100⠠280B00⢼065200⠤0B5200⠭000600⠡280600⢤000600⠥280600⠱002100⣤000600⠘004D00⢠000B00⠧280600⢕004700⢠001C00⡄280600⠥000600⡧001700⢠285200⡤007D00⢤001100⡄280B00⢥280600⠍284D00⠤280600⠧000600⠭004C00⢠004700⡄280600⠵280600⠥000600⠇002200⣠005200⠤001700⡄280600⠱000600⠬000600⠬000600⡔001700⠨0C7D00⠤292100⡅000600⠄000600⠄002800⠆000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⣘000100⠐000600⣨281700⢀0B2200⣘004C00⡃000600⣘000600⣐285200⠒000600⣃004D00⠘067D00⣀005200⠃000600⣊280600⣃004D00⢘001C00⡃280600⣋000600⡒117D00⢂004700⡀004D00⢀284C00⡄000600⣊000600⡃0B5200⣐280600⡃000600⣃285200⢘004D00⡂000B00⣃000600⣓001C00⢸005200⣃000B00⣂285200⣘001600⠇005200⠐004700⠂000600⣓000600⡙0BA900⢚0B7D00⣃280B00⣣000600⠐000600⡀002800⡂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠄002800⠦000100⠄000600⢦067D00⠤0B7D00⠤000B00⠣000600⡲280600⠴000600⠱000600⠢000600⠢004700⠉000600⠦000600⠢000600⡢001600⠈281600⠁000600⠦000600⠕001100⠈004700⠉001700⠉000B00⠵000600⠔000600⠔001700⠈280600⠔000600⠦001700⠈284C00⠉000C00⠁000600⠢000600⠢004700⠈051C00⠉004100⠁000600⠪000600⠢000600⠧280600⠣000600⠦007700⠸16A900⠤004D00⠄000600⠤000600⠠002800⠠002800⠁000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⢀000600⢀000600⢐000C00⢀065200⣀1CA900⣈007800⡃000600⣜280600⣪005200⢠284D00⡞005200⠙284C00⠛000600⣏004D00⢀067D00⡞007D00⠛067D00⢣285200⡀050B00⣝117D00⣑007D00⣄0B7D00⣘280B00⣍000600⣇067D00⢸06A900⣋004700⡁000600⣍285200⢘284C00⡇280600⣝003C00⢸297D00⡟004C00⠛007D00⣄280600⢑004D00⢀285200⡜005200⠙282100⢳004C00⡄280600⣏001100⠈11A900⢉11A900⣁281100⡄000600⡄000100⠂000100⡀002800⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⢢000100⢀000600⢂281100⠰064D00⠴0B4D00⡶000B00⠳280600⠶280600⡶001100⠘007D00⠶004C00⠤005200⠶280B00⢾001100⠘007D00⠶004D00⠤007D00⠶281100⠣280B00⣶064D00⠶051700⠘067D00⠶280B00⣷280B00⣶064D00⠰004100⠇050B00⣷280B00⣶064C00⠰051C00⠇280600⡶001100⠸067800⠦004D00⠴004D00⠇000600⣲001100⠘005200⠶001C00⠤005200⠶280C00⠃000600⢖000600⠧281C00⠸112100⠷281700⡦000600⡂000600⠂002800⠆002800⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⡨002800⡭000600⢅000600⢦064D00⢨17A900⣭28A900⡅280B00⣼280B00⣽007D00⢠00A900⣠007D00⣀007D00⣄007D00⣤287D00⣤287D00⣤287D00⣤287D00⣤287D00⣤287D00⣤287D00⣤067D00⣀287D00⣤287D00⣤287D00⣤287D00⣤28A900⣀287D00⣤287D00⣤287D00⣠287D00⣤287D00⣤284D00⣤287D00⣤284D00⣄004D00⣄284D00⣄004D00⣤005200⣄007D00⣄004D00⣤007D00⣄005200⣠280B00⡭050600⡯001100⠈0C5200⢩0B5200⣭281100⡅000600⢈000600⠈002800⡌000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⢐000600⠐000100⡈000600⢆280B00⣓06A900⣲16D400⡒001100⠃280B00⣷050B00⣷000C00⡘06A900⠳11A900⡒117D00⡒117D00⢒117D00⢒16A900⠒16A900⡒16A900⡒16A900⠒16A900⢒11A900⢒117D00⡒16A900⢒16A900⠒16A900⢒16A900⢒16A900⠒16A900⢒16A900⠒16A900⡒117D00⠒11A900⠒117D00⠒117D00⠒115200⡒114D00⡒105200⣒114D00⡒0B5200⣒114C00⢒107D00⠒0C5200⡒004700⠃280600⣺280B00⡲000600⣃00A900⢐117D00⡒281C00⣆000600⣒000600⢐000100⠐002800⠠000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠬000600⠔000600⠥000600⣭284D00⢨1CD400⢭29D400⡍000B00⣽280C00⢭060B00⠭060B00⡭000C00⣭06A900⠹16A900⡭16A900⠭16A900⡭16A900⢭1CA900⡭16A900⠭16A900⠭16A900⠭16A900⢭16A900⠭16A900⢭16A900⢭16A900⠭16A900⠭16A900⠭16A900⠭16A900⠭11A900⠭11A900⠭11A900⠭11A900⠭11A900⠭117D00⠭0B7D00⣭117D00⠭117D00⠭117D00⠭0B4D00⣭067D00⡭007800⠁280B00⣭280B00⣭280B00⣭280B00⢽004100⠈17A900⢭0BA900⣥000B00⡭000600⠤000600⠠000100⠁002800⢀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⡘000600⡀000600⡣280B00⣒281C00⣐0CD400⣐47D400⡒004100⣓061100⣒281100⣚060C00⢐281100⣒281100⣒051100⣓067700⠘16A900⢒1CA900⣒1CA900⣒17A900⣛1CA900⣒17A900⣒16A900⣒16A900⣒17A900⣒16A900⣒16A900⣓16A900⣒16A900⣒11A900⢒16A900⣒16A900⣒11A900⣒11A900⣒117D00⣒117D00⣒117D00⣒117D00⣒0C7D00⣒11A900⣒117D00⣒11A900⣒28A900⠛280B00⣳280B00⣳280B00⣓280B00⣗280B00⣳280B00⣻280C00⣀287D00⢘17A900⣒287800⡂280B00⣇000600⣃000600⢂000500⡀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠000600⠠000600⠨280600⠮281100⠤0B7D00⢤4CFF00⠤06D400⡇11FF00⠠06D400⣤061600⡬061600⠤061100⠥061100⠬061100⠬061100⠬067200⠈06A900⠽16A900⠭16A900⠭16A900⠭16A900⠭17A900⠭17A900⠭16A900⠭17A900⠭41A900⠭3CA900⠭107D00⠯0B2100⠭0CA900⠭16A900⠬16A900⠭16A900⠭16A900⠭16A900⠬16A900⠭167D00⠭11A900⠥117D00⠭117D00⠬287700⠏050B00⣽280B00⢯280B00⡯280B00⡯050B00⣯280B00⡿004700⢠06A900⠼067200⡌16D400⠭11D400⠤281600⠤280600⠤000600⠅000100⠄002800⠄000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⣘000600⣈000600⣚280B00⣻054700⢚17D400⣘21D700⣛0BA900⣁4CD400⣓21D400⣛6DD400⣓0BD400⣀061700⣛061700⣓061600⣓061100⣓291100⣛061100⣚28A400⠛16A900⣛16A900⣛16A900⣛16A900⣛16A900⣛16A900⣛16A900⣛17A900⣂16A900⣀0BA900⣀0B4D00⣛11A900⣀16A900⣀16A900⣚16A900⣛16A900⣛16A900⣛11A900⣛11A900⣛11A900⣛0B7D00⡛284700⠃060B00⣓280B00⣻280B00⣻280B00⣻060C00⢀284D00⢀06D400⣐11A900⣛11A900⣛11D400⣃29A900⢸1CD400⣛067D00⣂280B00⣏000600⣃000600⢑002800⢑000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠002800⠲000600⠦280600⡺281100⠴287D00⢴4CD400⠤0BD400⠇11D400⢼4CA900⠶4CD400⠤4CA900⠴4CA900⠾0BD400⣶0B4C00⡄061600⠶061100⠦061100⠦291100⠴061100⠤284700⠹11A900⠶16A900⠤16A900⠤16A900⠦16A900⠤17A900⠦16A900⠴16A900⠤117D00⠦0C7800⠴117D00⠶117D00⠴16A900⠴16A900⠤167D00⠴16A900⠤167D00⠦117D00⠦287800⠏281100⠵060B00⠴280B00⢿280B00⢿060B00⠴000C00⠖285200⢰0C7D00⠶167D00⠶16A900⠴167D00⠦16A900⠶064700⡮117D00⠿0B7D00⠧280C00⠦280600⠦000600⠢000600⠠002800⠂000000⠀000000⠀000000⠀000000⠀002800⢬000600⢡050600⣹050C00⣈061C00⣉1CD400⣸4CD400⣉16A900⣉7CD400⣉51D400⣉4CD400⣉77D400⣉77D400⣉51D400⣉51D400⣉11D400⣄0B7D00⡀0B1700⣍0B1100⣩0B1100⣉0B1100⣍067D00⠈11A900⢩47A900⣉47A900⣉47A900⣉47A900⣉47A900⣉47A900⣉17A900⣉1CA900⣉1CA900⣉17A900⣉47A900⣉1CA900⣉42A900⣉47A900⣉1CA900⣉28A900⠋061100⡁061100⡁060C00⢀060C00⢁060C00⠁06A900⣀11A900⣜47A900⣉1CA900⣉47A900⣉47A900⣉47A900⣉47D400⣉11D400⣁11A900⢉47A900⣉067D00⣁050B00⣯280600⣋000100⢌000500⠂002800⢀000000⠀000000⠀002800⠐000100⠐000600⡒280600⡶281100⢲067800⢲4DA900⠖11D400⠗0BA900⣾4CA900⠶4CA900⠶7CA900⠖4CA900⠶16A900⠺4CA900⠶21D400⠶1CA900⠶16D400⠶067D00⣆061600⠶061100⠲061100⠒061100⠒061100⠆06A900⠲17A900⠖16A900⠖17A900⠖177D00⠖16A900⠖16A900⠶167D00⠶167D00⠖16A900⠖16A900⠖16A900⠖16A900⠖0B7D00⠶061700⠃281100⠶280C00⠶060B00⠶280C00⠶064200⢀287D00⡶17A900⠲16A900⠲16A900⠖16A900⠶0BA900⠲1CA900⠶17A900⢶1CA900⠶1CD400⠶064C00⡖17D400⠶0BA900⡶290C00⠄280600⡖000600⠆000600⠂002800⠂000000⠀000000⠀002800⡡000600⡡000600⢭060B00⡨064700⢨17D400⣨78D400⡭16A900⢭4DD400⣭4CD400⢭4CD400⠭4CD400⠍17D400⡍16A900⣭16D400⢍47D400⠭4CD400⠍1CD400⣭1CD400⣭16A900⣧06A900⣄061700⢭061100⡭061600⡭061100⣭06D400⠉16A900⢭16A900⣭16A900⣭16D400⣭16A900⣭1BA900⣭17A900⣭16A900⣭16A900⣭16A900⣭0BA900⡍294700⠁061100⡉291100⡡061100⣁061100⢉287D00⣤16A900⣬16A900⣭16A900⣭17D400⠭16D400⠉11D400⠉105200⣭17D400⠉47D400⠩4CD400⢩4DD400⣩0BD400⣏11D700⢹1CD400⣍067800⣅061100⡀280600⡭000600⠌000100⠄002800⠄002800⠐000600⠐000600⡘280B00⣲061600⠐0B7D00⢲47D400⣖16D400⡓10D400⣲4CD400⠒4CD400⠒4CD400⠒17D400⡒16D400⣒16A900⡒16D400⣒17D400⡒1CD400⣒1CD400⠒1CD400⣒1CD400⢒1CD400⢒06D400⣖067200⡒061600⣒061600⣒281600⢒064700⠘0CA900⠒16A900⢒16A900⢒16A900⢒16A900⠒16A900⢒16A900⠒16A900⡒06A900⠒061100⠒061100⠒061100⠒061100⠒287700⣀0BD400⢒16A900⢒16A900⡒16A900⠒16A900⢒16D400⠒11D400⣒11A900⡖117D00⠒11D400⣖16D400⣒4CD400⠒4CD400⠒47D400⣒0B5200⡚21D700⠒0BD400⣖281700⣂280B00⣗000600⢓000100⠐002800⡐002800⠬000600⠌000600⡬280B00⣯061700⠬11D700⢬51D400⠭117D00⠭4CD400⠭4CD400⠭4CD400⠭4CD400⠭4CD400⠭4CD400⠭1CD400⠭51D400⠭4CD400⠭4CD400⠭4CD400⠭21D400⠭1CD400⠭1CD400⡭1CD400⠭6DD400⠥06D400⠤061600⠭061600⠭051100⣭284700⠬06A900⠹0B7D00⠯0B7D00⠭0BA900⠩0B7D00⠽067D00⠽287D00⠉061100⠬051100⠭291100⠭281C00⠩0BA900⠤16A900⠭16A900⠭16A900⢭1BD400⠭1CA900⠭1CD400⠭1CA900⠭1CD400⠭47D400⠭17D400⠬4CD400⠭47D400⠭4CD400⠭4CD400⠭4CD400⠭0BD400⡥11D400⠽1CD400⠭287800⡥051100⡅280600⠥000600⠅000100⠄002800⣚000600⣊280600⣺281100⣒28A900⢐77D400⣒16D400⡗11D400⣲4CD400⣒4CD400⣒4CD400⣒4CD400⣒4CD400⣒4DD400⣒4CD400⣒21D400⣓17D400⣓41D400⣛1CA900⣛1CD400⣚1CD400⣒1CD400⣐11A900⣖11D400⣒11A900⣲0CA900⣒06D400⣀281100⣛061100⣒061100⡂28A900⠙16A900⢒17A900⣒06A900⡛281600⠃051100⣚061100⡒287700⢀06A900⣰11D400⣒0CD400⣐0BA900⣒0C7D00⣢16D400⣀11D400⣀117800⣛11A900⣛11D400⣛11D400⡚17D400⠒4CD400⢒1CD400⣒1CD400⣒4CD400⣒4CD400⣒1CD400⣛47D400⣒0B7800⣚4CD400⣒0BD400⣂061600⡀280600⣓000600⣃000100⠁000600⠠000600⡢280B00⡯061700⠤11D700⢴4CD400⠤117D00⠥4CD400⠤47D400⠬16D400⠭16D400⠿1CD400⠭17D400⠤1CD400⠤11D400⠿1CD400⠭42D400⠤1CD400⠬1CD400⠬16D400⠭11A900⠯41D400⠤1CD400⠭17D400⠤1CD400⠤1CD400⠬17A900⠬06D400⠦281700⡄280C00⠥050C00⠥287700⠈004C00⠏003600⡽060B00⠬280C00⠭287D00⢠11A900⠬16A900⠬16A900⠤16A900⠤16A900⠬11A900⠤11A900⠬0BA900⠯11D400⠭11D400⠤11D400⠤11A900⠭0C7D00⠵0CD400⠤16D400⠤11A900⠭167D00⠽0CA900⠿11D400⠭17D400⠬0BD400⡥0BD400⠽47D400⠤064D00⠄280B00⡯000600⠦000600⠂000600⣈050600⣺281100⣙0BA900⣀4DD700⣛17D700⡋0BA900⣛16D400⣉47D400⣁72D400⣀4DD400⣐1CA900⣓17D400⣁72D400⣒4CD400⣐47D400⣒47D400⣒47D400⣒72D400⣐11A900⣛1CD400⣒47D400⣒1CA900⣀1CD400⣀16A900⣀11A900⣀11A900⣈10A900⣉367D00⣉064C00⣄280B00⣻280B00⣻280B00⣛050B00⣻281700⢠0B7800⣌37A900⣉0BA900⣉11A900⣀11A900⣀16A900⣀16A900⣀16A900⣀17A900⣀11A900⣂0B7D00⣐42A900⣐42D400⣀17A900⣒42D400⣐47D400⣒42D400⣀11A900⣐1CA900⣒47D400⣀1CD400⣀16D400⣈0BD400⣋067800⣙21D400⣛11D400⣃064C00⡀280600⣙000600⡐000600⠰280B00⡺281700⢴0BA900⢾1CA900⠷0B7800⠧1CD400⠾4CA900⠶4CD400⠤11A900⠿16A900⢤17A900⢶4CA900⠶4CA900⠶4CA900⠶4CA900⠶4CA900⠶47A900⠶17A900⠦0BA900⠶1CA900⠶1CA900⠶11A900⠶06A900⠷0B7700⠿114700⢋0B4D00⡥0B7D00⠤287D00⠶281700⠂280B00⢾280B00⠾000B00⠾280B00⠷280B00⡾007800⠲067D00⠦0B7800⡤0B4700⣍0B4C00⠚067800⠾06A900⠶117D00⠶167D00⠦0CA900⠦064700⠴16A900⠶16A900⠶16A900⠶1BA900⠴1CA900⠶1CA900⠦21A900⠶0BD400⠦0B7D00⠿16A900⠶17A900⠶4CD400⠤06A900⡆0BD400⢸16A900⠶064C00⠆280600⡶000600⠢280600⣩061000⢨0B7800⢩4CD400⣉47D400⡉11A900⣹4CD400⣉7CD400⣉17D400⣍16A900⣩4DD400⣉4CD400⣉4CD400⣉4CD400⣉77D400⣉77D400⣉7CD400⣉4CD400⣉1CD400⡍11A900⣉11A900⡉11A900⣥1CA900⣄47A900⣉1CA900⣉42A900⣉1CA900⡉06A900⠋061100⡁060B00⣩280B00⣟00A900⣠0BA900⣤284700⡀060B00⣉060B00⣅285200⠈0B7D00⢫16A900⣉17A900⣉47A900⣉41A900⣀0CA900⣤0B7D00⡍0B7800⣁117D00⡈1CA900⠉1CA900⣍1CA900⣉1CA900⣩47D400⣉4CD400⣉4CD400⣉47D400⣉17D400⣁11A900⡉47D400⢉4CD400⣉1CD400⣍0BA900⢈47D400⣉11A900⣁281100⡇280600⡍280600⠲281100⠶06A900⢸21D400⠲0B7D00⠗11D400⣾21A900⢶47D400⠖107D00⠲17A900⢲4CD400⠒4CA900⢶21D400⡶17D400⠒1CD400⠒47A900⠒16A900⣶11A900⣶1CD400⠖1CA900⠲0CA900⡶067800⣦0B1C00⡛06A900⠓067D00⠶06A900⠖281100⡳060B00⠶280C00⢲281100⢂007800⣴117D00⠒117D00⠒0B7D00⣶004700⣄280B00⢷280C00⢖050B00⣾064D00⠐067D00⠶287D00⠖064D00⠊064700⣀28A400⣴11A900⠖11A900⠶0BA900⣶0B7D00⣶114800⣶115200⡒11A900⠒11A900⠶1CA900⠲1CA900⠒1CA900⠲067D00⡖0B7D00⠺21D400⠖21D400⠲287700⡆0BA900⢲11A900⣶051600⡆280600⠖280B00⢩061100⠨42D400⢭4CD400⠭06A900⣌11FF00⠩21D400⣭1CD400⣭0B7D00⣭16D400⠭17D400⠉11D400⣩16A900⣭4CD400⡭4CD400⢭21D400⣭21D400⢭4CD400⠭21D400⣭17A900⣭16A900⣭1CD400⠭17A900⣭0BA900⡥051100⣭061100⡁061100⡁060C00⡡281100⣭067D00⠈0BA900⠉0BA900⠉0BA900⠉0BA900⠉0BA900⠉281100⣯061100⠁280C00⣭060C00⢁280C00⣭064700⠸16A900⣬11A900⣭16A900⣭16A900⣭1CA900⣭1CA900⣭1CD400⡭1CD400⡭16D400⣭1CA900⣭11A900⣤0B7D00⣭0BA900⡍11D400⠉067D00⠍0BA900⢨1CD400⣭0CD400⡭06D400⢉06A900⣬1CD400⡭067D00⡅000B00⡭000600⠂280B00⡳281100⠺06D400⠛1CD400⢒0BD400⣷0CA900⣌067D00⢛0CA900⣔0B5200⣒41D700⢒4CD400⡒4CD400⡒4CD400⡒1CD400⣒47D400⢒1CD400⣒1CD400⢒1CD400⡒1CD400⡒17A900⣒11D400⡒017D00⠃061100⡒061100⠒061100⠐281100⣒057800⣐11A900⣒11A900⣒117D00⣒117D00⡒16A900⣒11A900⣒16A900⣒16A900⣒06A900⣒287200⡐060C00⡀061100⠂281100⣒281100⣚067D00⠳16A900⣒16A900⡒16A900⡒16A900⣒16A900⣒16A900⣒16A900⣒1CD400⢒1CD400⡒1CD400⣒17A900⡒06A900⠒0BA400⢀0B7D00⡀284D00⢛06A900⣴1CD400⣒11D400⠒065200⠃280600⡒000600⡂000100⠈000600⠌000B00⠭281100⠩067200⠈0BD400⠩42D400⠭17D400⠥06D400⡍0BD400⠧067D00⣭11D400⠩11D400⠽21D400⠭21D400⠭1CD400⠭1CD400⠭17A900⠭1BA900⠭1BA900⠭06A900⠏287200⠩051100⢭060C00⠅050C00⡭281100⢭06A900⣤117D00⠭11A900⠭11A900⠭117D00⠭16A900⠭16A900⠭16A900⠭16A900⠭16A900⠭16A900⠭16A900⠥284C00⡄061100⠨290C00⠈060B00⠭060C00⠄287D00⠉0BA900⠭117D00⠭11A900⠭16A900⠭16A900⠭16A900⠭17A900⠭41A900⠭06A900⠏06A400⠁28D400⡤28A900⠏28A900⡤1CD400⠬11A900⠭28A300⠍004700⠉280600⠍000600⠅000100⠄002800⠈002800⢊000600⡑000600⡑000B00⣚280C00⠙061700⠛06A900⠛16A900⣛0BA900⣓01D400⣘11D400⢲0BD400⣀067D00⣛0BA900⠛17D400⠒1CA900⣚16A900⣚0BA900⡛284C00⠃281100⣚280C00⣛280C00⣚060C00⠐287D00⢀0BA900⣚11A900⣓11A900⣓11A900⣒11A900⣒11A900⣒11A900⣒11A900⣚11A900⣒16A900⣓11A900⣒11A900⣓11A900⣒16A900⣓06A900⣂001100⣓060B00⣓280B00⣻280B00⣟280C00⡂007D00⠛11A900⢒117D00⣒114D00⡛0BA900⠚287700⠛01A900⣀0B7D00⣰28A900⢛067D00⣐117D00⣚0B7D00⡚064C00⠛280B00⣛000B00⢛000600⠘000100⢈000100⠈002800⠐000000⠀000000⠀002800⠠002800⠱000100⠐000600⠌000600⠭280B00⠻287200⠩287D00⠿16D400⠬06A900⣦067D00⡝28D400⠿0CA900⠦06A900⣤286D00⡬287700⠉060B00⠵060B00⠭280B00⡿060B00⠥280B00⠿284C00⣠117D00⠤117D00⠤167D00⠤117D00⠤16A900⠤16A900⠤11A900⠤117D00⠤167D00⠤11A900⠤117D00⠤16A900⠤16A900⠤117D00⠤16A900⠤117D00⠬287D00⢦281100⡄280B00⡯280B00⡯280B00⢯280B00⠯284700⠈284700⠉281600⣠067D00⠤0B7D00⠶007700⠟005200⠡0CA900⠤06A900⠯284700⠏001100⠍000600⠄000600⠅000100⠐002800⠡000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠁000600⠁000600⠑000600⡉000600⡫280B00⣛067D00⠈06A900⠛16A900⣙067D00⣆28A900⡙00A900⠋061100⠁060C00⠈280B00⣻280B00⣻060B00⣊061100⢀067D00⣀284C00⣉287D00⠉067D00⠙06A900⠛0BA900⠛0C7D00⠛0BA400⠛0C7D00⠛0C7D00⠛117D00⠛0C7D00⠛0B7800⣛0C7D00⠛0B7D00⠛067D00⡛067D00⠛287D00⠛284D00⣉064C00⣁052200⡀050B00⣟280B00⣏050600⣻280B00⣹280B00⣛001C00⠈004D00⠛287D00⣁0C5200⣚104D00⣛295200⠋281700⠃000600⢑000600⠈000100⠐002800⠑000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠002800⠂000600⠂000600⠊000600⠲281100⠑281600⠞064C00⠳115200⠶284D00⢦001100⡀280B00⠾280B00⡿280B00⡷281100⢠287800⠶117800⠶117800⠶117800⠶117800⠶107800⠶0B4D00⠶0B7800⠶0B4D00⠶0B4D00⠶067800⠶0B7800⠶0B7800⡶0B7800⠶0B7800⠶0B7800⠶0B4D00⠶0B4D00⠶117800⠶117800⠶114700⠶0C4C00⠶001C00⡆280B00⠷050600⢷280600⠲000600⠗001700⣠004D00⠶064C00⠷281700⠟000B00⠯000600⠒002800⠜000100⠄002800⠂002800⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠁000100⠈000500⠁000600⢉000B00⢈000C00⠙285200⠉065200⢩165200⣁005200⣤281100⡉285200⢠167D00⣌167D00⣉167D00⣉16A900⣉16A900⣉167D00⣉167D00⣉167D00⣉167D00⣉16A900⣉16A900⣉16A900⣉16A900⣉16A900⣉17A900⣉167D00⣉167D00⣉167D00⣉167D00⣉167D00⣉167D00⣉115200⣍115200⣩112700⣉285200⣄280B00⡝005200⢠067D00⣼167D00⡉065200⠋281C00⠋000600⠈000600⡀000100⠁002800⠁002800⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠002800⠐002800⠪000600⠂000600⠳281C00⠘067D00⠲0B7D00⠒004700⣆007D00⠲117D00⠒117D00⠒114D00⠒117D00⠒117D00⠒117D00⠒117D00⠒11A900⠒11A900⠒11A900⠒11A900⠒11A900⠒11A900⠒117D00⠒117D00⠒117D00⠒117D00⠒117D00⠒11A900⠒117D00⠒0C7D00⠒117D00⠒007D00⠖001700⣃002200⣶0C2100⠒281C00⠗001100⠓002800⡚002800⠖000100⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠈002800⠈000600⠈000600⠈000600⠡001100⠉067D00⠉365200⢭0C5200⣥284D00⣌067D00⠩0B5200⣭0C7D00⢭115200⣭115200⢭105200⣭117D00⠭117D00⠭11A900⢭11A900⠭117D00⠭117D00⠭0C7D00⡭117D00⠭117D00⠭0B7D00⣭117D00⠭117D00⠭117D00⠭067D00⡭007D00⠉284D00⣤0B4D00⣭0B2100⠍001C00⠉000600⠩002800⠩000600⠈002800⠈000000⠀002800⠁000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠂000100⠂000100⠂000600⠊000B00⡺064C00⠐0B2200⢒065200⣒004D00⣀065200⠒117D00⢒117D00⣒117D00⣒0B5200⣒0C5200⣒0C4D00⣒107D00⣒117D00⣒11A900⣒117D00⣒117D00⠒117D00⣒117D00⣒117D00⣒067D00⡲005200⢃284C00⣰117D00⡒285200⠒001600⠓000600⢂000600⠂000100⠂002800⠐000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠂000600⠡000600⠠000B00⠈001100⠈064C00⠩0C5200⠭065200⠤004700⡌284200⠩284700⠉284700⠉064700⠉064700⠉064C00⠉067800⠉067700⠉054800⠉282100⠉284700⠉284700⠉284100⠉285200⠤0B5200⠬065200⠍004700⠉000B00⠅000600⠅000100⠄002800⠈002800⠈000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠐002800⠈002800⠚000100⠂000600⠊284100⠘064700⢛0B1C00⣛052100⣃002200⡐012100⢲0B5200⣒064D00⣒0B5200⣒065200⣒064D00⣒0B4D00⣒0B5200⡒002100⢒285200⣀0B2100⣚0B1C00⡓281700⠛000600⠉000100⠐000500⠂002800⠊000000⠀002800⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠈002800⠠000100⠈000500⠈000B00⠌001100⠹0B1700⠽061C00⠿281C00⠦004200⡙002100⠿062200⠦0B5200⠶115200⠤004C00⠟001C00⠡281C00⠾061C00⠿004100⠯000B00⠍002900⡵000100⠄000100⠂000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠂000100⠂000600⠁001100⠈281100⠻0B1C00⠙101C00⣛001C00⣆281C00⡙284D00⠛005200⣡064D00⣜0B2200⣁291700⡛004700⠁000600⠁000100⢀002800⠐000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠠002800⠐002800⠔000B00⠺284100⠰291C00⠶061C00⠶001700⠶0B1C00⠶281600⠟001100⠋000600⠁002800⠰000000⠀002800⠄000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀002800⠈002800⠈002800⡉000600⠁001600⠉001700⠉291C00⠝001600⠋000600⠉000600⠁002800⢉002800⠈000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀000000⠀]])

local width, height, scale, scaleMod = image.getWidth(source), image.getHeight(source), 1, 0.1
local targetMinimalScale, scaledWidth = 2 / width, width
local bufferWidth, bufferHeight = screen.getResolution()

while true do
	local transformed = image.transform(source, math.ceil(width * scale), height)
	screen.clear(0x0)
	screen.drawImage(math.floor(bufferWidth / 2 - image.getWidth(transformed) / 2), math.floor(bufferHeight / 2 - image.getHeight(transformed) / 2), transformed)
	screen.update()

	scale = scale - scaleMod
	if scale < targetMinimalScale then
		scale, scaleMod = targetMinimalScale, -scaleMod
	elseif scale > 1.0 then
		scale, scaleMod = 1.0, -scaleMod
	end

	local eventType = event.pull(0)
	if eventType == "touch" or eventType == "key_down" then
		break
	end
end
