/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.tiles;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;

public class FeralFlareLanternTileEntity
extends TileEntity
implements ITickableTileEntity {
    private FakePlayer fakePlayer;
    private int ticks;
    private boolean useLineOfSight;
    private List<BlockPos> childLights = new ArrayList<BlockPos>();

    public FeralFlareLanternTileEntity() {
        super(ModBlocks.tileFeralFlareLantern);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || ++this.ticks % (Integer)TorchmasterConfig.GENERAL.feralFlareTickRate.get() != 0) {
            return;
        }
        if (this.childLights.size() > (Integer)TorchmasterConfig.GENERAL.feralFlareLanternLightCountHardcap.get()) {
            return;
        }
        this.ticks = 0;
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)new GameProfile(UUID.fromString("2282ab80-e482-11e9-81b4-2a2ae2dbcce4"), "TorchMasterFeralFlareLantern"));
        }
        int radius = (Integer)TorchmasterConfig.GENERAL.feralFlareRadius.get();
        int diameter = radius * 2;
        int x = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177958_n();
        int y = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177956_o();
        int z = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177952_p();
        if (y < 3) {
            y = 3;
        }
        BlockPos targetPos = new BlockPos(x, y, z);
        BlockPos surfaceHeight = this.field_145850_b.func_205770_a(Heightmap.Type.WORLD_SURFACE, targetPos);
        if (targetPos.func_177956_o() > surfaceHeight.func_177956_o() + 4) {
            targetPos = surfaceHeight.func_177981_b(4);
        }
        int worldHeightCap = this.field_145850_b.func_217301_I();
        if (targetPos.func_177956_o() > worldHeightCap) {
            targetPos = new BlockPos(targetPos.func_177958_n(), worldHeightCap - 1, targetPos.func_177952_p());
        }
        if (!this.field_145850_b.func_175667_e(targetPos)) {
            return;
        }
        if (this.field_145850_b.func_175623_d(targetPos) && this.field_145850_b.func_226658_a_(LightType.BLOCK, targetPos) < (Integer)TorchmasterConfig.GENERAL.feralFlareMinLightLevel.get()) {
            BlockPos hitPos;
            Vector3d end;
            Vector3d start;
            RayTraceContext rtxCtx;
            BlockRayTraceResult rtResult;
            if (this.useLineOfSight && (rtResult = this.field_145850_b.func_217299_a(rtxCtx = new RayTraceContext(start = new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5), end = new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()).func_72441_c(0.5, 0.5, 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)this.fakePlayer))).func_216346_c() == RayTraceResult.Type.BLOCK && ((hitPos = rtResult.func_216350_a()).func_177958_n() != this.field_174879_c.func_177958_n() || hitPos.func_177956_o() != this.field_174879_c.func_177956_o() || hitPos.func_177952_p() != this.field_174879_c.func_177952_p())) {
                return;
            }
            if (this.field_145850_b.func_180501_a(targetPos, ModBlocks.blockInvisibleLight.func_176223_P(), 3)) {
                this.childLights.add(targetPos);
                this.func_70296_d();
            }
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        this.childLights.clear();
        if (nbt.func_150299_b("lights") == 11) {
            int[] lightsEncoded;
            BlockPos origin = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            for (int encodedLight : lightsEncoded = ((IntArrayNBT)nbt.func_74781_a("lights")).func_150302_c()) {
                this.childLights.add(FeralFlareLanternTileEntity.decodePosition(origin, encodedLight));
            }
        }
        this.ticks = nbt.func_74762_e("ticks");
        this.useLineOfSight = nbt.func_74767_n("useLoS");
        super.func_230337_a_(blockState, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        ArrayList<Integer> childLightsEncoded = new ArrayList<Integer>(this.childLights.size());
        for (BlockPos child : this.childLights) {
            childLightsEncoded.add(FeralFlareLanternTileEntity.encodePosition(this.field_174879_c, child));
        }
        nbt.func_218657_a("lights", (INBT)new IntArrayNBT(childLightsEncoded));
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74757_a("useLoS", this.useLineOfSight);
        return super.func_189515_b(nbt);
    }

    public void setUseLineOfSight(boolean state) {
        this.useLineOfSight = state;
        this.func_70296_d();
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
    }

    public boolean shouldUseLineOfSight() {
        return this.useLineOfSight;
    }

    public void removeChildLights() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (BlockPos pos : this.childLights) {
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() != ModBlocks.blockInvisibleLight) continue;
            this.field_145850_b.func_217377_a(pos, false);
        }
        this.childLights.clear();
    }

    private static int encodePosition(BlockPos origin, BlockPos target) {
        int x = target.func_177958_n() - origin.func_177958_n();
        int y = target.func_177956_o() - origin.func_177956_o();
        int z = target.func_177952_p() - origin.func_177952_p();
        return ((x & 0xFF) << 16) + ((y & 0xFF) << 8) + (z & 0xFF);
    }

    private static BlockPos decodePosition(BlockPos origin, int pos) {
        byte x = (byte)(pos >> 16 & 0xFF);
        byte y = (byte)(pos >> 8 & 0xFF);
        byte z = (byte)(pos & 0xFF);
        return origin.func_177982_a((int)x, (int)y, (int)z);
    }
}

