/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.net.handler;

import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;

final class PacketHandlerUtil {
    private PacketHandlerUtil() {
    }

    static NetworkRegistry.ChannelBuilder buildLenientHandler(String id, int protocolVersion) {
        String verStr = Integer.toString(protocolVersion);
        Predicate<String> validator = PacketHandlerUtil.validateLenient(verStr);
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("worldedit", id)).clientAcceptedVersions(validator).serverAcceptedVersions(validator).networkProtocolVersion(() -> verStr);
    }

    private static Predicate<String> validateLenient(String protocolVersion) {
        return remoteVersion -> protocolVersion.equals(remoteVersion) || NetworkRegistry.ABSENT.equals(remoteVersion) || NetworkRegistry.ACCEPTVANILLA.equals(remoteVersion);
    }
}

