/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.internal.util.Substring;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.enginehub.piston.Command;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;

public final class CommandWrapper {
    private CommandWrapper() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, org.enginehub.piston.Command command) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        aliases.add((Object)command.getName()).addAll(command.getAliases());
        Command commandRunner = ctx -> {
            WorldEdit.getInstance().getEventBus().post(new CommandEvent(FabricAdapter.adaptPlayer(((class_2168)ctx.getSource()).method_9207()), ctx.getInput()));
            return 0;
        };
        for (String alias : aliases.build()) {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)alias).executes(commandRunner)).then(class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandWrapper::suggest).executes(commandRunner));
            if (command.getCondition() != Command.Condition.TRUE) {
                base.requires(CommandWrapper.requirementsFor(command));
            }
            dispatcher.register(base);
        }
    }

    private static Predicate<class_2168> requirementsFor(org.enginehub.piston.Command mapping) {
        return ctx -> {
            class_1297 entity = ctx.method_9228();
            if (!(entity instanceof class_3222)) {
                return true;
            }
            FabricPlayer actor = FabricAdapter.adaptPlayer((class_3222)entity);
            MapBackedValueStore store = MapBackedValueStore.create();
            store.injectValue(Key.of(Actor.class), context -> Optional.of(actor));
            return mapping.getCondition().satisfied(store);
        };
    }

    private static CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        CommandSuggestionEvent event = new CommandSuggestionEvent(FabricAdapter.adaptPlayer(((class_2168)context.getSource()).method_9207()), builder.getInput());
        WorldEdit.getInstance().getEventBus().post(event);
        List<Substring> suggestions = event.getSuggestions();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Substring suggestion : suggestions) {
            String suggestionText = suggestion.getSubstring();
            if (suggestion.getStart() == suggestion.getEnd() && suggestion.getEnd() == builder.getInput().length() && !builder.getInput().endsWith(" ") && !builder.getInput().endsWith("\"")) {
                suggestionText = " " + suggestionText;
            }
            result.add((Object)new Suggestion(StringRange.between((int)suggestion.getStart(), (int)suggestion.getEnd()), suggestionText));
        }
        return CompletableFuture.completedFuture(Suggestions.create((String)builder.getInput(), (Collection)result.build()));
    }
}

