/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.digitality.lib;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import site.hellishmods.digitality.init.CommonPackInit;
import site.hellishmods.digitality.lib.VirtualCommonPack;
import site.hellishmods.digitality.templates.CubeAllModelTemplate;
import site.hellishmods.digitality.templates.ItemModelTemplate;
import site.hellishmods.digitality.templates.SoundEventTemplate;
import site.hellishmods.digitality.templates.SoundTemplate;

public class VirtualResourcePack
extends VirtualCommonPack {
    public VirtualResourcePack(String modid) {
        super(modid);
        this.dir = CommonPackInit.assetDir.toPath().resolve(modid);
    }

    public void sound(File ogg, String name, String category) {
        name = FilenameUtils.removeExtension((String)name);
        this.customAsset(ogg, name + ".ogg", "sounds");
        SoundTemplate soundObject = new SoundTemplate();
        soundObject.name = String.format("%s:%s", this.modid, name);
        soundObject.steam = category == "record";
        SoundEventTemplate soundEvent = new SoundEventTemplate();
        soundEvent.category = category;
        soundEvent.sounds.add(soundObject);
        this.addJsonKey(this.dir.resolve("sounds.json").toFile(), name, soundEvent);
    }

    public void sound(File ogg, String category) {
        this.sound(ogg, ogg.getName(), category);
    }

    public void sound(Path ogg, String name, String category) {
        this.sound(ogg.toFile(), name, category);
    }

    public void sound(Path ogg, String category) {
        this.sound(ogg.toFile(), ogg.toFile().getName(), category);
    }

    public void texture(String type, File file, String name) {
        name = FilenameUtils.removeExtension((String)name);
        File mcemeta = file.toPath().resolveSibling(FilenameUtils.removeExtension((String)file.getName()) + ".png.mcmeta").toFile();
        this.customAsset(file, name + ".png", "textures", type);
        if (mcemeta.exists()) {
            this.customAsset(mcemeta, name + ".png.mcmeta", "textures", type);
        }
    }

    public void texture(String type, File file) {
        this.texture(type, file, file.getName());
    }

    public void texture(String type, Path file, String name) {
        this.texture(type, file.toFile(), name);
    }

    public void texture(String type, Path file) {
        this.texture(type, file.toFile(), file.toFile().getName());
    }

    public void itemModel(String name, String ... layers) {
        ItemModelTemplate modelJson = new ItemModelTemplate();
        for (int i = 0; i < layers.length; ++i) {
            modelJson.textures.addProperty("layer" + i, String.format("%s:item/%s", this.modid, layers[i]));
        }
        this.newJson(this.dir.resolve("models").resolve("item").resolve(name + ".json").toFile(), modelJson);
    }

    public void blockAllModel(String name, String texture) {
        this.newJson(this.dir.resolve("models").resolve("block").resolve(name + ".json").toFile(), new CubeAllModelTemplate(String.format("%s:block/%s", this.modid, texture)));
    }

    public void lang(String key, String value, String lang) {
        this.addJsonKey(this.dir.resolve("lang").resolve(FilenameUtils.removeExtension((String)lang) + ".json").toFile(), key, value);
    }

    public void lang(String key, String value) {
        this.lang(key, value, "en_us");
    }
}

