/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.digitality.lib;

import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import site.hellishmods.digitality.init.CommonPackInit;
import site.hellishmods.digitality.lib.VirtualCommonPack;
import site.hellishmods.digitality.templates.ItemTemplate;
import site.hellishmods.digitality.templates.ShapelessRecipeTemplate;
import site.hellishmods.digitality.templates.TagTemplate;
import site.hellishmods.digitality.util.ExceptionHandler;

public class VirtualDataPack
extends VirtualCommonPack {
    public VirtualDataPack(String modid) {
        super(modid);
        this.dir = CommonPackInit.dataDir.toPath().resolve(modid);
    }

    public void shapelessRecipe(String id, ItemTemplate result, ArrayList<String> ingredients) {
        ShapelessRecipeTemplate recipe = new ShapelessRecipeTemplate();
        recipe.result = result;
        for (String ingredient : ingredients) {
            recipe.ingredients.add(new ItemTemplate(ingredient));
        }
        this.newJson(this.dir.resolve("recipes").resolve(id + ".json").toFile(), recipe);
    }

    public void shapelessRecipe(String id, ItemTemplate result, String ... ingredients) {
        this.shapelessRecipe(id, result, new ArrayList<String>(Arrays.asList(ingredients)));
    }

    public void itemTag(String tag, String ... newItems) {
        try {
            TagTemplate tagJson;
            File tagfile = this.dir.resolve("tags").resolve("items").resolve(tag + ".json").toFile();
            tagfile.getParentFile().mkdirs();
            if (tagfile.exists()) {
                tagJson = (TagTemplate)this.GSON.fromJson(new JsonReader((Reader)new FileReader(tagfile)), TagTemplate.class);
            } else {
                tagfile.createNewFile();
                tagJson = new TagTemplate();
            }
            tagJson.values.addAll(Arrays.asList(newItems));
            tagJson.values = new ArrayList(tagJson.values.stream().distinct().collect(Collectors.toList()));
            this.newJson(tagfile, tagJson);
        }
        catch (IOException e) {
            new ExceptionHandler(e);
        }
    }
}

