/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.digitality.lib;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import site.hellishmods.digitality.init.CommonPackInit;
import site.hellishmods.digitality.util.ExceptionHandler;

public abstract class VirtualCommonPack {
    protected String modid;
    protected Path dir;
    protected final Gson GSON = new Gson();

    protected VirtualCommonPack(String id) {
        if (CommonPackInit.tmpDir == null) {
            CommonPackInit.generate();
        }
        this.modid = id;
    }

    private void writeJson(File file, Object object) throws IOException {
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter writer = new FileWriter(file);
        writer.write(this.GSON.toJson(object));
        writer.close();
    }

    protected void newJson(File file, Object object) {
        try {
            file.delete();
            this.writeJson(file, object);
        }
        catch (IOException e) {
            new ExceptionHandler(e);
        }
    }

    protected void addJsonKey(File file, String key, Object value) {
        try {
            JsonObject json = file.exists() ? new JsonParser().parse(new JsonReader((Reader)new FileReader(file))).getAsJsonObject() : new JsonObject();
            json.add(key, this.GSON.toJsonTree(value));
            this.writeJson(file, json);
        }
        catch (IOException e) {
            new ExceptionHandler(e);
        }
    }

    public void customAsset(File originalFile, String name, String ... assetPath) {
        try {
            File path = Paths.get(this.dir.toString(), assetPath).resolve(name).toFile();
            path.getParentFile().mkdirs();
            path.delete();
            FileUtils.copyFile((File)originalFile, (File)path);
        }
        catch (IOException e) {
            new ExceptionHandler(e);
        }
    }

    public void customAsset(Path originalFile, String name, String ... assetPath) {
        this.customAsset(originalFile.toFile(), name, assetPath);
    }

    public void customAsset(Object obj, String name, String ... assetPath) {
        this.newJson(Paths.get(this.dir.toString(), assetPath).resolve(name).toFile(), obj);
    }
}

