/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.digitality.init;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.apache.commons.io.FileUtils;
import site.hellishmods.digitality.digitality;
import site.hellishmods.digitality.init.ResourcePackInit;
import site.hellishmods.digitality.util.ExceptionHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="digitality")
public class CommonPackInit {
    public static Path tmpDir;
    public static File assetDir;
    public static File dataDir;

    public static void generate() {
        try {
            tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("digitality");
            tmpDir.toFile().mkdirs();
            digitality.LOGGER.info("Created virtual pack: " + tmpDir);
            File pack = new File(tmpDir.toFile(), "pack.mcmeta");
            pack.createNewFile();
            FileWriter packwriter = new FileWriter(pack);
            packwriter.write("{\"pack\": {\"pack_format\": 6, \"description\": \"DigitalityAPI's auto-loaded resources\"}}");
            packwriter.close();
            assetDir = tmpDir.resolve("assets").toFile();
            dataDir = tmpDir.resolve("data").toFile();
            assetDir.mkdir();
            dataDir.mkdir();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException err) {
                    new ExceptionHandler(err);
                }
            }));
        }
        catch (IOException err) {
            new ExceptionHandler(err);
        }
    }

    @SubscribeEvent
    static void onConstruct(FMLConstructModEvent e) {
        if (tmpDir == null) {
            CommonPackInit.generate();
        }
        ResourcePackInit.load();
    }
}

