/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EditListScreen
extends Screen
implements IBackgroundTexture {
    private static final Map<IConfigValue<List<?>>, ListType> TYPE_CACHE = new HashMap();
    private final Screen parent;
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final ResourceLocation background;
    private final IConfigValue<List<?>> holder;
    private final ListType listType;
    private ObjectList list;

    public EditListScreen(Screen parent, ITextComponent titleIn, IConfigValue<List<?>> holder, ResourceLocation background) {
        super(titleIn);
        this.parent = parent;
        this.holder = holder;
        this.listType = EditListScreen.getType(holder);
        this.values.addAll(holder.get().stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).collect(Collectors.toList()));
        this.background = background;
    }

    protected void func_231160_c_() {
        this.list = new ObjectList();
        this.list.func_244605_b(!ListMenuScreen.isPlayingGame());
        this.field_230705_e_.add(this.list);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 140, this.field_230709_l_ - 29, 90, 20, DialogTexts.field_240632_c_, button -> {
            List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
            this.holder.set(newValues);
            this.field_230706_i_.func_147108_a(this.parent);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 45, this.field_230709_l_ - 29, 90, 20, (ITextComponent)new TranslationTextComponent("configured.gui.add_value"), button -> this.field_230706_i_.func_147108_a((Screen)new EditStringScreen(this, this.background, (ITextComponent)new TranslationTextComponent("configured.gui.edit_value"), "", s -> {
            Object value = this.listType.getValueParser().apply((String)s);
            return value != null && this.holder.isValid(Collections.singletonList(value));
        }, s -> {
            StringHolder holder = new StringHolder((String)s);
            this.values.add(holder);
            this.list.addEntry(new StringEntry(this.list, holder));
        }))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 50, this.field_230709_l_ - 29, 90, 20, DialogTexts.field_240633_d_, button -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        EditListScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)14, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    protected static ListType getType(IConfigValue<List<?>> holder) {
        return TYPE_CACHE.computeIfAbsent(holder, value -> ListType.fromHolder(holder));
    }

    protected static enum ListType {
        BOOLEAN(Object::toString, Boolean::valueOf),
        INTEGER(Object::toString, Ints::tryParse),
        LONG(Object::toString, Longs::tryParse),
        DOUBLE(Object::toString, Doubles::tryParse),
        STRING(Object::toString, o -> o),
        UNKNOWN(Object::toString, o -> o);

        final Function<Object, String> stringParser;
        final Function<String, ?> valueParser;

        private ListType(Function<Object, String> stringParser, Function<String, ?> valueParser) {
            this.stringParser = stringParser;
            this.valueParser = valueParser;
        }

        public Function<Object, String> getStringParser() {
            return this.stringParser;
        }

        public Function<String, ?> getValueParser() {
            return this.valueParser;
        }

        protected static ListType fromHolder(IConfigValue<List<?>> holder) {
            ListType type = UNKNOWN;
            List<?> defaultList = holder.getDefault();
            if (!defaultList.isEmpty()) {
                type = ListType.fromObject(defaultList.get(0));
            }
            if (type == UNKNOWN) {
                type = ListType.fromElementValidator(holder);
            }
            return type;
        }

        protected static ListType fromObject(Object o) {
            if (o instanceof Boolean) {
                return BOOLEAN;
            }
            if (o instanceof Integer) {
                return INTEGER;
            }
            if (o instanceof Long) {
                return LONG;
            }
            if (o instanceof Double) {
                return DOUBLE;
            }
            if (o instanceof String) {
                return STRING;
            }
            return UNKNOWN;
        }

        private static ListType fromElementValidator(IConfigValue<List<?>> spec) {
            if (spec.isValid(Collections.singletonList("s"))) {
                return STRING;
            }
            if (spec.isValid(Collections.singletonList(true))) {
                return BOOLEAN;
            }
            if (spec.isValid(Collections.singletonList(0.0))) {
                return DOUBLE;
            }
            if (spec.isValid(Collections.singletonList(0L))) {
                return LONG;
            }
            if (spec.isValid(Collections.singletonList(0))) {
                return INTEGER;
            }
            return UNKNOWN;
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringEntry
    extends AbstractOptionList.Entry<StringEntry> {
        private final StringHolder holder;
        private final ObjectList list;
        private final Button editButton;
        private final Button deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new Button(0, 0, 42, 20, (ITextComponent)new StringTextComponent("Edit"), onPress -> EditListScreen.this.field_230706_i_.func_147108_a((Screen)new EditStringScreen(EditListScreen.this, EditListScreen.this.background, (ITextComponent)new TranslationTextComponent("configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                return value != null && EditListScreen.this.holder.isValid(Collections.singletonList(value));
            }, s -> this.holder.setValue((String)s))));
            Button.ITooltip tooltip = (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_230693_o_ && button.func_230449_g_()) {
                    EditListScreen.this.func_238654_b_(matrixStack, ((EditListScreen)EditListScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.remove"), Math.max(EditListScreen.this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            }, tooltip);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((EditListScreen)EditListScreen.this).field_230706_i_.field_71466_p.func_243246_a(matrixStack, (ITextComponent)new StringTextComponent(this.holder.getValue()), (float)(left + 5), (float)(top + 6), 0xFFFFFF);
            this.editButton.field_230694_p_ = true;
            this.editButton.field_230690_l_ = left + width - 65;
            this.editButton.field_230691_m_ = top;
            this.editButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.deleteButton.field_230694_p_ = true;
            this.deleteButton.field_230690_l_ = left + width - 21;
            this.deleteButton.field_230691_m_ = top;
            this.deleteButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.editButton, (Object)this.deleteButton);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ObjectList
    extends ExtendedList<StringEntry>
    implements IBackgroundTexture {
        public ObjectList() {
            super(EditListScreen.this.field_230706_i_, EditListScreen.this.field_230708_k_, EditListScreen.this.field_230709_l_, 36, EditListScreen.this.field_230709_l_ - 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 144;
        }

        public int func_230949_c_() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.func_230513_b_((AbstractList.AbstractListEntry)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.func_230956_e_((AbstractList.AbstractListEntry)entry);
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.func_231039_at__().forEach(entry -> entry.func_231039_at__().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).func_230443_a_(matrixStack, mouseX, mouseY);
                }
            }));
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return EditListScreen.this.background;
        }
    }
}

