/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class SteepRoof
extends RoofBlock {
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BASE_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OCCLUSION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape OCCLUSION_BOTTOM = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;

    public SteepRoof(BlockState state, AbstractBlock.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld level, BlockPos pos, BlockPos newPos) {
        return direction.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((Property)SHAPE, (Comparable)SteepRoof.getStairsShape((IBlockReader)level, pos, (Direction)state.func_177229_b((Property)FACING), (Half)state.func_177229_b(HALF))) : super.func_196271_a(state, direction, newState, level, pos, newPos);
    }

    private static StairsShape getStairsShape(IBlockReader reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(direction));
        if (SteepRoof.isSteepRoof(blockstate) && half == blockstate.func_177229_b(HALF) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && SteepRoof.canTakeShape(direction1.func_176734_d(), blockstate, reader, pos)) {
            return direction1 == direction.func_176735_f() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (SteepRoof.isSteepRoof(blockstate1) && half == blockstate1.func_177229_b(HALF) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && SteepRoof.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.func_176735_f() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(dir));
        return !SteepRoof.isSteepRoof(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || blockstate.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isSteepRoof(BlockState state) {
        return state.func_177230_c() instanceof SteepRoof;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader getter, BlockPos pos) {
        if (state.func_177229_b(HALF) == Half.BOTTOM) {
            return OCCLUSION;
        }
        return OCCLUSION_BOTTOM;
    }
}

