/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class Steep
extends RoofBlock {
    protected static final VoxelShape WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape EAST = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OUTER_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OUTER_EAST = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape OUTER_SOUTH = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OUTER_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape INNER_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    protected static final VoxelShape INNER_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    protected static final VoxelShape INNER_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape INNER_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));

    public Steep(BlockState state, AbstractBlock.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld level, BlockPos pos, BlockPos newPos) {
        return direction.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((Property)SHAPE, (Comparable)Steep.getStairsShape((IBlockReader)level, pos, (Direction)state.func_177229_b((Property)FACING), (Half)state.func_177229_b((Property)HALF))) : super.func_196271_a(state, direction, newState, level, pos, newPos);
    }

    private static StairsShape getStairsShape(IBlockReader reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(direction));
        if (Steep.isSteep(blockstate) && half == blockstate.func_177229_b((Property)HALF) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && Steep.canTakeShape(direction1.func_176734_d(), blockstate, reader, pos)) {
            return direction1 == direction.func_176735_f() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (Steep.isSteep(blockstate1) && half == blockstate1.func_177229_b((Property)HALF) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && Steep.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.func_176735_f() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(dir));
        return !Steep.isSteep(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || blockstate.func_177229_b((Property)HALF) != state.func_177229_b((Property)HALF);
    }

    public static boolean isSteep(BlockState state) {
        return state.func_177230_c() instanceof Steep;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader getter, BlockPos pos) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_RIGHT) {
                    return OUTER_NORTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_LEFT) {
                    return OUTER_WEST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_LEFT) {
                    return INNER_EAST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_RIGHT) {
                    return INNER_WEST;
                }
                return WEST;
            }
            case EAST: {
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_RIGHT) {
                    return OUTER_SOUTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_LEFT) {
                    return OUTER_EAST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_LEFT) {
                    return INNER_NORTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_RIGHT) {
                    return INNER_SOUTH;
                }
                return EAST;
            }
            case SOUTH: {
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_RIGHT) {
                    return OUTER_WEST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_LEFT) {
                    return OUTER_SOUTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_LEFT) {
                    return INNER_SOUTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_RIGHT) {
                    return INNER_EAST;
                }
                return SOUTH;
            }
            case NORTH: {
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_RIGHT) {
                    return OUTER_EAST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.OUTER_LEFT) {
                    return OUTER_NORTH;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_LEFT) {
                    return INNER_WEST;
                }
                if (state.func_177229_b((Property)SHAPE) == StairsShape.INNER_RIGHT) {
                    return INNER_NORTH;
                }
                return NORTH;
            }
        }
        return null;
    }
}

