/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class RoofBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    protected static final VoxelShape TOP_SIDE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_SIDE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NNN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SHAPE_NNP = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NPN = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_NPP = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_PNN = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SHAPE_PNP = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_PPN = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_PPP = Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = RoofBlock.createStairShapes(TOP_SIDE, SHAPE_NNN, SHAPE_PNN, SHAPE_NNP, SHAPE_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = RoofBlock.createStairShapes(BOTTOM_SIDE, SHAPE_NPN, SHAPE_PPN, SHAPE_NPP, SHAPE_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] createStairShapes(VoxelShape baseShape, VoxelShape ... shapes) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(index -> RoofBlock.createStairShape(index, baseShape, shapes)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape createStairShape(int bitmask, VoxelShape baseShape, VoxelShape ... shapes) {
        VoxelShape resultShape = baseShape;
        for (int i = 0; i < shapes.length; ++i) {
            if ((bitmask & 1 << i) == 0) continue;
            resultShape = VoxelShapes.func_197872_a((VoxelShape)resultShape, (VoxelShape)shapes[i]);
        }
        return resultShape;
    }

    public RoofBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        VoxelShape[] shapes = state.func_177229_b(HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES;
        int shapeIndex = this.getShapeIndex(state);
        return shapes[SHAPE_BY_STATE[shapeIndex]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!state.func_203425_a(state.func_177230_c())) {
            level.func_190524_a(pos, Blocks.field_150350_a, pos);
            this.func_220082_b(statetwo, level, pos, statetwo, false);
        }
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!state.func_203425_a(statetwo.func_177230_c())) {
            this.func_196243_a(statetwo, level, pos, statetwo, bool);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            StairsShape shape = (StairsShape)state.func_177229_b(SHAPE);
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            StairsShape nextShape = this.getNextShape(shape);
            if (nextShape == StairsShape.STRAIGHT) {
                facing = facing.func_176746_e();
            }
            state = (BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)nextShape)).func_206870_a((Property)FACING, (Comparable)facing);
            worldIn.func_180501_a(pos, state, 1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private StairsShape getNextShape(StairsShape currentShape) {
        switch (currentShape) {
            case STRAIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.STRAIGHT;
            }
        }
        return StairsShape.STRAIGHT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        Direction horizontalDirection = context.func_195992_f();
        Half half = !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP;
        StairsShape shape = RoofBlock.getStairsShape((IBlockReader)context.func_195991_k(), blockpos, horizontalDirection, half);
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)horizontalDirection)).func_206870_a(HALF, (Comparable)half)).func_206870_a(SHAPE, (Comparable)shape);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld level, BlockPos pos, BlockPos newPos) {
        return direction.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a(SHAPE, (Comparable)RoofBlock.getStairsShape((IBlockReader)level, pos, (Direction)state.func_177229_b((Property)FACING), (Half)state.func_177229_b(HALF))) : super.func_196271_a(state, direction, newState, level, pos, newPos);
    }

    private static StairsShape getStairsShape(IBlockReader reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(direction));
        if (RoofBlock.isRoof(blockstate) && half == blockstate.func_177229_b(HALF) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && RoofBlock.canTakeShape(direction1.func_176734_d(), blockstate, reader, pos)) {
            return direction1 == direction.func_176735_f() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (RoofBlock.isRoof(blockstate1) && half == blockstate1.func_177229_b(HALF) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != facing.func_176740_k() && RoofBlock.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.func_176735_f() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState blockstate = reader.func_180495_p(pos.func_177972_a(dir));
        return !RoofBlock.isRoof(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || blockstate.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isRoof(BlockState state) {
        return state.func_177230_c() instanceof RoofBlock;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (mirror == Mirror.LEFT_RIGHT && direction.func_176740_k() == Direction.Axis.Z) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
        }
        if (mirror == Mirror.FRONT_BACK && direction.func_176740_k() == Direction.Axis.X) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
        }
        return super.func_185471_a(state, mirror);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HALF, SHAPE});
    }

    public boolean isPathfindable(IBlockReader state, BlockPos pos, PathType type) {
        return false;
    }
}

