/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.ItemInit;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RainGutter
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    private static final BooleanProperty WATER = BooleanProperty.func_177716_a((String)"water");
    private static final VoxelShape SIDE_S = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_E = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_W = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SIDE_N = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_N = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_E = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_S = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape OUTER_W = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)12.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape CORNER_N = VoxelShapes.func_197872_a((VoxelShape)SIDE_N, (VoxelShape)SIDE_E);
    protected static final VoxelShape CORNER_E = VoxelShapes.func_197872_a((VoxelShape)SIDE_E, (VoxelShape)SIDE_S);
    protected static final VoxelShape CORNER_S = VoxelShapes.func_197872_a((VoxelShape)SIDE_S, (VoxelShape)SIDE_W);
    protected static final VoxelShape CORNER_W = VoxelShapes.func_197872_a((VoxelShape)SIDE_W, (VoxelShape)SIDE_N);

    public RainGutter(BlockState state, AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)RainGutter.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                switch ((StairsShape)state.func_177229_b(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_W;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_E;
                    }
                    case OUTER_LEFT: {
                        return OUTER_N;
                    }
                    case INNER_LEFT: {
                        return CORNER_S;
                    }
                }
                return CORNER_W;
            }
            case EAST: {
                switch ((StairsShape)state.func_177229_b(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_E;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_W;
                    }
                    case OUTER_LEFT: {
                        return OUTER_S;
                    }
                    case INNER_LEFT: {
                        return CORNER_N;
                    }
                }
                return CORNER_E;
            }
            case SOUTH: {
                switch ((StairsShape)state.func_177229_b(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_S;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_N;
                    }
                    case OUTER_LEFT: {
                        return OUTER_W;
                    }
                    case INNER_LEFT: {
                        return CORNER_E;
                    }
                }
                return CORNER_S;
            }
            case NORTH: {
                switch ((StairsShape)state.func_177229_b(SHAPE)) {
                    case STRAIGHT: {
                        return SIDE_N;
                    }
                    case OUTER_RIGHT: {
                        return OUTER_S;
                    }
                    case OUTER_LEFT: {
                        return OUTER_E;
                    }
                    case INNER_LEFT: {
                        return CORNER_W;
                    }
                }
                return CORNER_N;
            }
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        Boolean i = (Boolean)state.func_177229_b((Property)WATER);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.func_235896_a_(SHAPE);
            world.func_180501_a(pos, state, 2);
        }
        if (item == Items.field_151131_as && !i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        if (item == Items.field_151133_ar && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            itemstack.func_190918_g(1);
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
        }
        if (item == Items.field_151069_bo && i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)WATER);
            world.func_180501_a(pos, state, 2);
            player.func_184611_a(hand, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b));
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)RainGutter.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (RainGutter.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (RainGutter.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof RainGutter;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected boolean isRainingday(World world, BlockPos pos) {
        return world.func_175727_C(pos);
    }

    public boolean func_149653_t(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177981_b(30);
        if (world.func_175727_C(blockpos) && !((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(true)));
        }
        if (!world.func_175727_C(blockpos) && ((Boolean)state.func_177229_b((Property)WATER)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATER, FACING, SHAPE});
    }
}

