/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.moderncustomdiscs.items;

import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.RegistryObject;
import site.hellishmods.digitality.lib.VirtualDataPack;
import site.hellishmods.moderncustomdiscs.items.CustomDiscItem;
import site.hellishmods.moderncustomdiscs.items.DiscConfig;
import site.hellishmods.moderncustomdiscs.moderncustomdiscs;

public class Disc {
    final VirtualDataPack TAG_REGISTER = new VirtualDataPack("minecraft");
    public final RegistryObject<CustomDiscItem> DISC_ITEM;
    public final RegistryObject<SoundEvent> SOUND;
    public final File TEXTURE;
    public final String ID;
    public DiscConfig config;

    public Disc(String name, DiscConfig config, File texture) {
        this.config = config;
        this.TEXTURE = texture;
        this.ID = "disc_" + name;
        if (config.name == null) {
            config.name = name;
        }
        String desc = config.author == null ? config.name : config.author + " \u2014 " + config.name;
        moderncustomdiscs.RESOURCES.lang(String.format("item.%s.%s.desc", "moderncustomdiscs", this.ID), desc);
        if (texture.exists()) {
            moderncustomdiscs.RESOURCES.texture("item", texture, this.ID);
            moderncustomdiscs.RESOURCES.itemModel(this.ID, new String[]{this.ID});
        } else {
            moderncustomdiscs.RESOURCES.itemModel(this.ID, new String[]{"disc_base", "disc_center1", "disc_center2"});
        }
        this.SOUND = moderncustomdiscs.MUSIC.register(name, () -> new SoundEvent(new ResourceLocation("moderncustomdiscs", name)));
        this.DISC_ITEM = moderncustomdiscs.DISCS.register(this.ID, () -> new CustomDiscItem(this.SOUND, config.redstone, desc));
        this.TAG_REGISTER.itemTag("music_discs", new String[]{"moderncustomdiscs:" + this.ID});
        if (config.creeper) {
            this.TAG_REGISTER.itemTag("creeper_drop_music_discs", new String[]{"moderncustomdiscs:" + this.ID});
        }
    }
}

