/*
 * Decompiled with CFR 0.152.
 */
package site.hellishmods.moderncustomdiscs.init;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import site.hellishmods.moderncustomdiscs.items.Disc;
import site.hellishmods.moderncustomdiscs.items.DiscConfig;
import site.hellishmods.moderncustomdiscs.moderncustomdiscs;
import site.hellishmods.moderncustomdiscs.util.ExceptionHandler;

public class DiscInit {
    static final Gson JSON_LOADER = new Gson();
    static final File CONFIG = FMLPaths.CONFIGDIR.get().resolve("moderncustomdiscs").toFile();
    public static final ArrayList<Disc> DISC_ITEMS = new ArrayList();
    static File[] discs;

    public static final void GenerateDiscs() throws FileNotFoundException {
        if (!CONFIG.exists()) {
            CONFIG.mkdirs();
        }
        for (File disc : discs = CONFIG.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".ogg"))) {
            moderncustomdiscs.RESOURCES.sound(disc, "record");
            String id = FilenameUtils.removeExtension((String)disc.getName());
            DiscConfig json = new DiscConfig();
            File jsonfile = CONFIG.toPath().resolve(id + ".json").toFile();
            if (jsonfile.exists()) {
                JsonReader reader = new JsonReader((Reader)new FileReader(jsonfile));
                try {
                    json = (DiscConfig)JSON_LOADER.fromJson(reader, DiscConfig.class);
                }
                catch (JsonSyntaxException e) {
                    new ExceptionHandler((Exception)((Object)e), id);
                }
            }
            File texture = CONFIG.toPath().resolve(id + ".png").toFile();
            DISC_ITEMS.add(new Disc(id, json, texture));
        }
    }
}

