/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.register.config;

import com.kotakotik.createautomated.register.config.ModClientConfig;
import com.kotakotik.createautomated.register.config.ModCommonConfig;
import com.kotakotik.createautomated.register.config.ModServerConfig;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static ModCommonConfig COMMON;
    public static ModServerConfig SERVER;
    public static ModClientConfig CLIENT;
    static Map<Config, ModConfig.Type> configs;

    private static <T extends Config> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            Config config = (Config)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        Config config = (Config)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        configs.put(config, side);
        return (T)((Object)config);
    }

    public static void register() {
        COMMON = ModConfig.register(ModCommonConfig::new, ModConfig.Type.COMMON);
        SERVER = ModConfig.register(ModServerConfig::new, ModConfig.Type.SERVER);
        CLIENT = ModConfig.register(ModClientConfig::new, ModConfig.Type.CLIENT);
        for (Map.Entry<Config, ModConfig.Type> pair : configs.entrySet()) {
            ModLoadingContext.get().registerConfig(pair.getValue(), pair.getKey().specification);
        }
    }

    public static void onLoad(ModConfig.Loading event) {
        for (Map.Entry<Config, ModConfig.Type> pair : configs.entrySet()) {
            if (pair.getKey().specification != event.getConfig().getSpec()) continue;
            pair.getKey().onLoad();
        }
    }

    public static void onReload(ModConfig.Reloading event) {
        for (Map.Entry<Config, ModConfig.Type> pair : configs.entrySet()) {
            if (pair.getKey().specification != event.getConfig().getSpec()) continue;
            pair.getKey().onReload();
        }
    }

    static {
        configs = new HashMap<Config, ModConfig.Type>();
    }

    public static class Config
    extends ConfigBase {
        protected void registerAll(ForgeConfigSpec.Builder builder) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            if (this.allValues == null) {
                this.allValues = new ArrayList();
            }
            super.registerAll(builder);
        }

        public String getName() {
            return StringUtils.uncapitalize((String)((Object)((Object)this)).getClass().getSimpleName());
        }
    }
}

