/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.content.worldgen;

import com.kotakotik.createautomated.register.ModConfigAnnotations;
import com.kotakotik.createautomated.register.config.ModConfig;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeature;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeatureConfig;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class DimensionalConfigDrivenFeatureEntry
extends ConfigDrivenFeatureEntry {
    private final Function<ForgeConfigSpec.Builder, FilterConfig> defaultBiomes;
    private final Function<ForgeConfigSpec.Builder, FilterConfig> defaultBlocks;
    private final Function<ForgeConfigSpec.Builder, FilterConfig> defaultCategories;
    Optional<ConfiguredFeature<?, ?>> cachedFeature = Optional.empty();
    public FilterConfig biomes;
    public FilterConfig blocks;
    public FilterConfig categories;

    public DimensionalConfigDrivenFeatureEntry(String id, NonNullSupplier<? extends Block> block, int clusterSize, float frequency, Function<ForgeConfigSpec.Builder, FilterConfig> defaultBiomes, Function<ForgeConfigSpec.Builder, FilterConfig> defaultBlocks, Function<ForgeConfigSpec.Builder, FilterConfig> defaultCategories) {
        super(id, block, clusterSize, frequency);
        this.defaultBiomes = defaultBiomes;
        this.defaultBlocks = defaultBlocks;
        this.defaultCategories = defaultCategories;
    }

    public static DimensionalConfigDrivenFeatureEntry nether(String id, NonNullSupplier<? extends Block> block, int clusterSize, float frequency) {
        return new DimensionalConfigDrivenFeatureEntry(id, block, clusterSize, frequency, b -> DimensionalConfigDrivenFeatureEntry.biomeConfig(true, Collections.emptyList()), b -> DimensionalConfigDrivenFeatureEntry.blockConfig(false, Collections.singletonList("#" + Tags.Blocks.NETHERRACK.func_230234_a_())), b -> DimensionalConfigDrivenFeatureEntry.categoryConfig(false, Collections.singletonList(Biome.Category.NETHER.func_222352_a())));
    }

    public static DimensionalConfigDrivenFeatureEntry overworld(String id, NonNullSupplier<? extends Block> block, int clusterSize, float frequency) {
        return new DimensionalConfigDrivenFeatureEntry(id, block, clusterSize, frequency, b -> DimensionalConfigDrivenFeatureEntry.biomeConfig(true, Collections.emptyList()), b -> DimensionalConfigDrivenFeatureEntry.blockConfig(false, Collections.singletonList("#" + Tags.Blocks.DIRT.func_230234_a_())), b -> DimensionalConfigDrivenFeatureEntry.categoryConfig(true, Arrays.asList(Biome.Category.NETHER.func_222352_a(), Biome.Category.THEEND.func_222352_a())));
    }

    public ConfiguredFeature<?, ?> getFeature() {
        if (!this.cachedFeature.isPresent()) {
            this.cachedFeature = Optional.of(this.createFeature());
        }
        return this.cachedFeature.get();
    }

    public boolean blockMatches(ResourceLocation id, Set<ResourceLocation> tags) {
        return ((List)this.blocks.list.get()).stream().anyMatch(l -> {
            if (l.startsWith("#")) {
                return tags.contains(new ResourceLocation(l.replace("#", "")));
            }
            return new ResourceLocation(l).equals((Object)id);
        }) != ((Boolean)this.blocks.blacklist.get()).booleanValue();
    }

    public RuleTest createTest() {
        return new BlockMatchRuleTest(Blocks.field_150350_a){

            public boolean func_215181_a(BlockState state, Random random) {
                return DimensionalConfigDrivenFeatureEntry.this.blockMatches(state.func_177230_c().getRegistryName(), state.func_177230_c().getTags());
            }

            protected IRuleTestType<?> func_215180_a() {
                return IRuleTestType.field_214912_c;
            }
        };
    }

    protected ConfiguredFeature<?, ?> createFeature() {
        ConfigDrivenOreFeatureConfig config = new ConfigDrivenOreFeatureConfig(this.createTest(), ((Block)this.block.get()).func_176223_P(), this.id){

            protected ConfigDrivenFeatureEntry entry() {
                return DimensionalConfigDrivenFeatureEntry.this;
            }

            public float getFrequency() {
                return (Boolean)ModConfig.COMMON.worldGen.enabled.get() != false ? DimensionalConfigDrivenFeatureEntry.this.frequency.getF() : 0.0f;
            }
        };
        return ConfigDrivenOreFeature.INSTANCE.func_225566_b_((IFeatureConfig)config).func_227228_a_(ConfigDrivenDecorator.INSTANCE.func_227446_a_((IPlacementConfig)config));
    }

    public static FilterConfig biomeConfig(boolean blacklistEnabled, List<String> conf) {
        return new FilterConfig("biomes", $ -> true, blacklistEnabled, "biomes", conf, new String[0]);
    }

    public static FilterConfig blockConfig(boolean blacklistEnabled, List<String> conf) {
        return new FilterConfig("blocks", $ -> true, blacklistEnabled, "blocks", conf, new String[0]);
    }

    public static FilterConfig categoryConfig(boolean blacklistEnabled, List<String> conf) {
        return new FilterConfig("categories", $ -> true, blacklistEnabled, "categories", conf, new String[0]);
    }

    protected void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(ModConfigAnnotations.screenUnsupported("lists"));
        this.biomes = this.defaultBiomes.apply(builder);
        builder.push(this.biomes.getName());
        this.biomes.registerAll(builder);
        builder.pop();
        builder.comment(new String[]{ModConfigAnnotations.screenUnsupported("lists"), "Start with # if is a tag"});
        this.blocks = this.defaultBlocks.apply(builder);
        builder.push(this.blocks.getName());
        this.blocks.registerAll(builder);
        builder.pop();
        builder.comment(ModConfigAnnotations.screenUnsupported("lists"));
        this.categories = this.defaultCategories.apply(builder);
        builder.push(this.categories.getName());
        this.categories.registerAll(builder);
        builder.pop();
        super.registerAll(builder);
    }

    public boolean biomeMatches(ResourceLocation name) {
        return ((List)this.biomes.list.get()).stream().anyMatch(l -> new ResourceLocation(l).equals((Object)name)) != ((Boolean)this.biomes.blacklist.get()).booleanValue();
    }

    public boolean categoryMatches(String name) {
        return ((List)this.categories.list.get()).stream().anyMatch(s -> s.equals(name)) != ((Boolean)this.categories.blacklist.get()).booleanValue();
    }

    public boolean shouldRegister(BiomeLoadingEvent event) {
        return this.biomeMatches(event.getName()) && this.categoryMatches(event.getCategory().func_222352_a());
    }

    public static class FilterConfig
    extends ModConfig.Config {
        protected final String name;
        protected final Predicate<String> validator;
        protected final boolean blacklistEnabledByDefault;
        protected final String listName;
        public ConfigBase.ConfigBool blacklist;
        private final List<String> defaults;
        private final String[] listDescription;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> list;

        public FilterConfig(String name, Predicate<String> validator, boolean blacklistEnabledByDefault, String listName, List<String> defaults, String ... description) {
            this.name = name;
            this.validator = validator;
            this.blacklistEnabledByDefault = blacklistEnabledByDefault;
            this.listName = listName;
            this.blacklist = this.b(blacklistEnabledByDefault, "blacklist", new String[]{"Whether or not this filter is in blacklist mode", ModConfigAnnotations.hide()});
            this.defaults = defaults;
            this.listDescription = description;
        }

        @Override
        protected void registerAll(ForgeConfigSpec.Builder builder) {
            String[] comments = new String[this.listDescription.length + 1];
            comments[0] = ModConfigAnnotations.hide();
            System.arraycopy(this.listDescription, 0, comments, 1, this.listDescription.length);
            builder.comment(comments);
            this.list = builder.defineList(this.listName, this.defaults, o -> o instanceof String && this.validator.test((String)o));
            super.registerAll(builder);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

