/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.content.processing.picker;

import com.kotakotik.createautomated.content.processing.picker.recipe.PickingRecipe;
import com.kotakotik.createautomated.register.ModRecipeTypes;
import com.kotakotik.createautomated.register.config.ModConfig;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;

public class PickerItem
extends Item {
    public PickerItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ModConfig.SERVER.machines.picker.durability.get();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity plr, Hand hand) {
        AxisAlignedBB bb;
        ItemStack stack = plr.func_184586_b(hand);
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Picking")) {
            plr.func_184598_c(hand);
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        Hand otherHand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        Optional<PickingRecipe> pickingRecipe = PickerItem.getRecipe(world, plr.func_184586_b(otherHand));
        if (pickingRecipe.isPresent()) {
            ItemStack item = plr.func_184586_b(otherHand).func_77946_l();
            ItemStack toPick = item.func_77979_a(1);
            plr.func_184598_c(hand);
            tag.func_218657_a("Picking", (INBT)toPick.serializeNBT());
            plr.func_184611_a(otherHand, item);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (plr instanceof DeployerFakePlayer) {
            bb = plr.func_174813_aQ().func_72317_d(-0.5, -0.5, -0.5).func_72314_b(0.3, 0.0, 0.3);
            bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e - 0.8, bb.field_72334_f);
        } else {
            BlockRayTraceResult raytraceresult = PickerItem.func_219968_a((World)world, (PlayerEntity)plr, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (!(raytraceresult instanceof BlockRayTraceResult)) {
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            BlockRayTraceResult ray = raytraceresult;
            Vector3d hitVec = ray.func_216347_e();
            bb = new AxisAlignedBB(hitVec, hitVec).func_186662_g(1.0);
        }
        ItemEntity pickUp = null;
        for (ItemEntity itemEntity : world.func_217357_a(ItemEntity.class, bb)) {
            ItemStack toPick;
            if (!itemEntity.func_70089_S() || itemEntity.func_213303_ch().func_72438_d(plr.func_213303_ch()) > 3.0 || !PickerItem.getRecipe(world, toPick = itemEntity.func_92059_d()).isPresent()) continue;
            pickUp = itemEntity;
            break;
        }
        if (pickUp == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        ItemStack item = pickUp.func_92059_d().func_77946_l();
        ItemStack toPick = item.func_77979_a(1);
        plr.func_184598_c(hand);
        if (!world.field_72995_K) {
            tag.func_218657_a("Picking", (INBT)toPick.serializeNBT());
            if (item.func_190926_b()) {
                pickUp.func_70106_y();
            } else {
                pickUp.func_92058_a(item);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.EAT;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Picking")) {
            ItemStack toPick = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Picking"));
            player.field_71071_by.func_191975_a(worldIn, toPick);
            tag.func_82580_o("Picking");
        }
    }

    public static BlockPos getDeployerClickingPos(DeployerFakePlayer deployer) {
        return new BlockPos(deployer.func_226277_ct_(), deployer.func_226278_cu_(), deployer.func_226281_cx_());
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity plr = (PlayerEntity)entity;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Picking")) {
            ItemStack toPick = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Picking"));
            List<ItemStack> outputs = PickerItem.getRecipe(world, toPick).get().generateOutputs();
            if (plr instanceof DeployerFakePlayer && !world.field_72995_K) {
                Vector3d motion = VecHelper.offsetRandomly((Vector3d)Vector3d.field_186680_a, (Random)world.field_73012_v, (float)0.125f);
                BlockPos p2 = PickerItem.getDeployerClickingPos((DeployerFakePlayer)plr);
                SSpawnParticlePacket packet = new SSpawnParticlePacket((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, toPick), false, (double)p2.func_177958_n() + 0.5, (double)p2.func_177956_o() + 0.5, (double)p2.func_177952_p() + 0.5, (float)motion.field_72450_a, (float)motion.field_72448_b, (float)motion.field_72449_c, 0.2f, 20);
                ServerWorld serverWorld = (ServerWorld)world;
                serverWorld.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(p2, p2).func_186662_g(10.0)).stream().forEach(pp -> pp.field_71135_a.func_147359_a((IPacket)packet));
            } else {
                SandPaperItem.spawnParticles((Vector3d)entity.func_174824_e(1.0f).func_178787_e(entity.func_70040_Z().func_186678_a(0.5)), (ItemStack)toPick, (World)world);
            }
            if (world.field_72995_K) {
                return stack;
            }
            if (plr instanceof FakePlayer) {
                outputs.forEach(o -> plr.func_146097_a(o, false, false));
            } else {
                outputs.forEach(o -> plr.field_71071_by.func_191975_a(world, o));
            }
            tag.func_82580_o("Picking");
            stack.func_222118_a(1, entity, p -> p.func_213334_d(p.func_184600_cs()));
        }
        return stack;
    }

    public static Optional<PickingRecipe> getRecipe(World world, ItemStack toPick) {
        return world.func_199532_z().func_215371_a((IRecipeType)ModRecipeTypes.PICKING, (IInventory)new PickingRecipe.PickingInventory(toPick), world);
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return (Integer)ModConfig.SERVER.machines.picker.useTime.get();
    }
}

