/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.content.processing.oreExtractor;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.kotakotik.createautomated.api.DrillPartialIndex;
import com.kotakotik.createautomated.content.processing.oreExtractor.OreExtractorTile;
import com.kotakotik.createautomated.register.ModBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticData;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import java.lang.reflect.Field;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class OreExtractorInstance
extends KineticTileInstance<OreExtractorTile>
implements IDynamicInstance {
    public static final Field isRemovedField = ObfuscationReflectionHelper.findField(InstanceData.class, (String)"removed");
    public static final Field rotationOffsetField = ObfuscationReflectionHelper.findField(KineticData.class, (String)"rotationOffset");
    public RotatingData drill;
    public Instancer<RotatingData> shortModel;
    public Instancer<RotatingData> model;
    protected RotatingData rotatingModel;

    protected BlockState getRenderedBlockState() {
        return this.blockState;
    }

    public OreExtractorInstance(MaterialManager<?> modelManager, OreExtractorTile tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.shortModel = this.materialManager.defaultTransparent().material(AllMaterialSpecs.ROTATING).getModel(ModBlockPartials.HALF_SHAFT_COGWHEEL, ((OreExtractorTile)this.tile).func_195044_w());
        this.model = this.materialManager.defaultTransparent().material(AllMaterialSpecs.ROTATING).getModel(ModBlockPartials.COGWHEEL, ((OreExtractorTile)this.tile).func_195044_w());
        this.rotatingModel = this.setup((RotatingData)this.model.createInstance());
        if (tile.durability > 0) {
            this.createDrill();
        }
    }

    public RotatingData createDrill() {
        this.drill = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(DrillPartialIndex.get(((OreExtractorTile)this.tile).drillId), this.blockState).createInstance();
        this.drill.setRotationAxis(Direction.Axis.Y);
        this.updateDrillRotation();
        this.drill.setPosition(this.getInstancePosition().func_177977_b());
        this.shortModel.stealInstance((InstanceData)this.rotatingModel);
        return this.drill;
    }

    public void updateDrillRotation() {
        this.drill.setRotationalSpeed(((OreExtractorTile)this.tile).getSpeed());
        try {
            this.drill.setRotationOffset(((Float)rotationOffsetField.get(this.rotatingModel)).floatValue());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.drill.setRotationAxis(super.getRotationAxis());
    }

    public void deleteDrill() {
        this.drill.delete();
        this.model.stealInstance((InstanceData)this.rotatingModel);
        this.updateLight();
    }

    public void beginFrame() {
    }

    public boolean isDrillRemoved() {
        if (this.drill == null) {
            return true;
        }
        try {
            return (Boolean)isRemovedField.get(this.drill);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void update() {
        if (((OreExtractorTile)this.tile).durability <= 0) {
            if (!this.isDrillRemoved()) {
                this.deleteDrill();
            }
        } else if (this.isDrillRemoved()) {
            this.createDrill();
        }
        if (!this.isDrillRemoved()) {
            this.updateDrillRotation();
            this.updateLight();
            BlockPos p = this.getInstancePosition();
            this.drill.setPosition((float)p.func_177958_n(), (float)(p.func_177956_o() - 1) + ((OreExtractorTile)this.tile).drillPos, (float)p.func_177952_p());
        }
        this.updateRotation(this.rotatingModel);
        super.update();
    }

    public void updateLight() {
        super.updateLight();
        if (!this.isDrillRemoved()) {
            this.relight(this.pos.func_177977_b(), new IFlatLight[]{this.drill});
        }
        this.relight(this.pos, new IFlatLight[]{this.rotatingModel});
    }

    public void remove() {
        this.rotatingModel.delete();
        if (this.drill != null) {
            this.drill.delete();
        }
    }
}

