/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import com.mojang.brigadier.CommandDispatcher;
import mcjty.theoneprobe.commands.ModCommands;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.playerdata.PlayerGotNote;
import mcjty.theoneprobe.playerdata.PlayerProperties;
import mcjty.theoneprobe.playerdata.PropertiesDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !((Entity)event.getObject()).getCapability(PlayerProperties.PLAYER_GOT_NOTE).isPresent()) {
            event.addCapability(new ResourceLocation("theoneprobe", "properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            LazyOptional capability = event.getOriginal().getCapability(PlayerProperties.PLAYER_GOT_NOTE);
            capability.ifPresent(oldStore -> event.getPlayer().getCapability(PlayerProperties.PLAYER_GOT_NOTE).ifPresent(newStore -> newStore.copyFrom((PlayerGotNote)oldStore)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)Config.spawnNote.get()).booleanValue()) {
            event.getPlayer().getCapability(PlayerProperties.PLAYER_GOT_NOTE).ifPresent(note -> {
                boolean success;
                if (!note.isPlayerGotNote() && (success = event.getPlayer().field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.probeNote)))) {
                    note.setPlayerGotNote(true);
                }
            });
        }
    }
}

