/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RotaryKilnRecipeSerializer
extends IERecipeSerializer<RotaryKilnRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IIContent.IIMultiblocks.rotary_kiln);
    }

    public RotaryKilnRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize((JsonElement)json.get("input"));
        FluidStack result_fluid = FluidStack.EMPTY;
        if (json.has("result_fluid")) {
            result_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result_fluid"));
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = (Integer)IIConfig.COMMON.rotaryKilnBase.get();
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        ItemStack byout = ItemStack.field_190927_a;
        float chance = 0.0f;
        if (json.has("byproduct")) {
            byout = this.readOutput(json.get("byproduct"));
            chance = 1.0f;
            if (json.has("chance")) {
                chance = json.get("chance").getAsFloat();
            }
        }
        return new RotaryKilnRecipe(recipeId, output, input, result_fluid, time, tickEnergy, byout, chance);
    }

    @Nullable
    public RotaryKilnRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        return new RotaryKilnRecipe(recipeId, buffer.func_150791_c(), IngredientWithSize.read((PacketBuffer)buffer), FluidStack.readFromPacket((PacketBuffer)buffer), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150791_c(), buffer.readFloat());
    }

    public void write(PacketBuffer buffer, RotaryKilnRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        recipe.input.write(buffer);
        recipe.output_fluid.writeToPacket(buffer);
        buffer.func_150787_b(recipe.time);
        buffer.func_150787_b(recipe.tickEnergy);
        buffer.func_150788_a(recipe.secoutput);
        buffer.writeFloat(recipe.secoutputchance);
    }
}

