/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IndustrialElectrolyzerTileEntity
extends MultiblockPartTileEntity<IndustrialElectrolyzerTileEntity>
implements IEBlockInterfaces.IBlockBounds,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IProcessTile {
    public int process = 0;
    public int processMax = 0;
    public int tickEnergy = 0;
    public ItemStack result = ItemStack.field_190927_a;
    public FluidStack resultFluid = FluidStack.EMPTY;
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(32000);
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, null);
    public FluidTank[] tank = new FluidTank[]{new FluidTank(16000, ElectrolyzerRecipe::isValidRecipeFluid), new FluidTank(16000)};
    private static BlockPos out1 = new BlockPos(3, 0, 3);
    private static BlockPos out2 = new BlockPos(-1, 0, 3);
    private CapabilityReference<IItemHandler> outputCap1 = CapabilityReference.forTileEntityAt((TileEntity)this, () -> {
        Direction fw = this.getFacing().func_176735_f();
        return new DirectionalBlockPos(this.getBlockPosForPos(out1), fw);
    }, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private CapabilityReference<IItemHandler> outputCap2 = CapabilityReference.forTileEntityAt((TileEntity)this, () -> {
        Direction fw = this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.getBlockPosForPos(out2), fw);
    }, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private CapabilityReference<IFluidHandler> outputfCap1 = CapabilityReference.forTileEntityAt((TileEntity)this, () -> {
        Direction fw = this.getFacing().func_176735_f();
        return new DirectionalBlockPos(this.getBlockPosForPos(out1), fw);
    }, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    private CapabilityReference<IFluidHandler> outputfCap2 = CapabilityReference.forTileEntityAt((TileEntity)this, () -> {
        Direction fw = this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.getBlockPosForPos(out2), fw);
    }, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    LazyOptional<IItemHandler> inHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 0, true, false));
    LazyOptional<IItemHandler> outHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 4, false, true));

    public IndustrialElectrolyzerTileEntity() {
        super(IIContent.IIMultiblocks.IND_ELE, (TileEntityType)IIContent.IITileTypes.IND_ELE.get(), true);
    }

    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        if (master != null && side.func_96559_d() == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177958_n() != 1) {
            if (this.posInMultiblock.func_177952_p() == 1) {
                return master.tank;
            }
            if (this.posInMultiblock.func_177952_p() == 3) {
                return master.tank;
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int i, Direction side, FluidStack fluidStack) {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        if (i != 0) {
            return false;
        }
        if (master != null && side.func_96559_d() == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177958_n() != 1 && this.posInMultiblock.func_177952_p() == 1) {
            return ElectrolyzerRecipe.isValidRecipeFluid(fluidStack);
        }
        return false;
    }

    protected boolean canDrainTankFrom(int i, Direction side) {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        if (i != 1) {
            return false;
        }
        return master != null && side.func_96559_d() == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177958_n() != 1 && this.posInMultiblock.func_177952_p() == 3;
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
        this.tank[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tank[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        if (!descPacket) {
            this.result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result"));
            this.resultFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("result_fluid"));
            this.tickEnergy = nbt.func_74762_e("tickEnergy");
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_218657_a("tank0", (INBT)this.tank[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tank[1].writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        if (!descPacket) {
            nbt.func_218657_a("result", (INBT)this.result.serializeNBT());
            nbt.func_218657_a("result_fluid", (INBT)this.resultFluid.writeToNBT(new CompoundNBT()));
            nbt.func_74768_a("tickEnergy", this.tickEnergy);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.isDummy() && !this.field_145850_b.field_72995_K) {
            int energyConsume = this.tickEnergy * 6;
            double elconsume = (Double)IIConfig.COMMON.electrodeCost.get();
            this.tryOutput();
            if (!this.isRSDisabled() && this.energyStorage.getEnergyStored() >= energyConsume && this.hasElectrodes()) {
                ElectrolyzerRecipe recipe;
                if (this.process > 0) {
                    int duracost = 0;
                    if (elconsume > 0.0) {
                        duracost = (int)elconsume;
                        double npart = MathHelper.func_181162_h((double)elconsume);
                        if ((double)this.func_145831_w().field_73012_v.nextInt(1000) < npart * 1000.0) {
                            ++duracost;
                        }
                    }
                    if (duracost > 0) {
                        for (int ele = 2; ele < 4; ++ele) {
                            if (!((ItemStack)this.inventory.get(ele)).func_96631_a(duracost, Utils.RAND, null)) continue;
                            this.inventory.set(ele, (Object)ItemStack.field_190927_a);
                        }
                    }
                    this.process -= 8;
                    this.energyStorage.extractEnergy(energyConsume, false);
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                if (!this.result.func_190926_b()) {
                    if (((ItemStack)this.inventory.get(4)).func_190926_b()) {
                        this.inventory.set(4, (Object)this.result);
                        this.result = ItemStack.field_190927_a;
                        this.processMax = 0;
                        this.process = 0;
                        this.tickEnergy = 0;
                        this.markContainingBlockForUpdate(null);
                    } else if (((ItemStack)this.inventory.get(4)).func_77969_a(this.result)) {
                        ((ItemStack)this.inventory.get(4)).func_190917_f(this.result.func_190916_E());
                        this.result = ItemStack.field_190927_a;
                        this.processMax = 0;
                        this.process = 0;
                        this.tickEnergy = 0;
                        this.markContainingBlockForUpdate(null);
                    } else {
                        return;
                    }
                }
                if (!this.resultFluid.isEmpty()) {
                    int filled = this.tank[1].fill(this.resultFluid, IFluidHandler.FluidAction.EXECUTE);
                    if (filled < this.resultFluid.getAmount()) {
                        this.resultFluid.shrink(filled);
                        return;
                    }
                    this.resultFluid = FluidStack.EMPTY;
                }
                if ((recipe = this.getRecipe()) != null) {
                    FluidStack matching;
                    if (recipe.inputs.length > 0) {
                        ItemStack[] consumed = new ItemStack[recipe.inputs.length];
                        int ix = -1;
                        for (IngredientWithSize iws : recipe.inputs) {
                            int i;
                            block26: {
                                for (i = 0; i < 2; ++i) {
                                    if (!iws.test((ItemStack)this.inventory.get(i))) {
                                        continue;
                                    }
                                    break block26;
                                }
                                block3: for (ItemStack is : consumed) {
                                    int i2;
                                    if (is == null) continue;
                                    for (i2 = 0; i2 < 2; ++i2) {
                                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)is, (ItemStack)((ItemStack)this.inventory.get(i2)))) continue;
                                        Utils.modifyInvStackSize(this.inventory, (int)i2, (int)is.func_190916_E());
                                        continue block3;
                                    }
                                    for (i2 = 0; i2 < 2; ++i2) {
                                        if (!((ItemStack)this.inventory.get(i2)).func_190926_b()) continue;
                                        this.inventory.set(i2, (Object)is);
                                        continue block3;
                                    }
                                }
                                this.markContainingBlockForUpdate(null);
                                return;
                            }
                            consumed[++ix] = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(i)), (int)iws.getCount());
                            Utils.modifyInvStackSize(this.inventory, (int)i, (int)(-iws.getCount()));
                        }
                    }
                    this.processMax = this.process = recipe.time;
                    this.tickEnergy = recipe.tickEnergy;
                    if (recipe.input_fluid != null) {
                        this.tank[0].drain(recipe.input_fluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.result = recipe.output.func_77946_l();
                    if (recipe.output_fluid != null && !(matching = recipe.output_fluid).isEmpty()) {
                        this.resultFluid = matching.copy();
                    }
                    this.markContainingBlockForUpdate(null);
                }
            } else if (this.process != this.processMax) {
                this.process = this.processMax;
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    public void tryOutput() {
        boolean update = false;
        if (this.tank[1].getFluidAmount() > 0) {
            int drained;
            IFluidHandler output;
            int accepted;
            FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)this.tank[1].getFluid(), (int)Math.min(this.tank[1].getFluidAmount(), 80), (boolean)false);
            if (this.outputfCap1.isPresent() && (accepted = (output = (IFluidHandler)this.outputfCap1.getNullable()).fill(out, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                this.tank[1].drain(drained, IFluidHandler.FluidAction.EXECUTE);
                out.shrink(accepted);
                update |= true;
            }
            if (!out.isEmpty() && this.outputfCap2.isPresent() && (accepted = (output = (IFluidHandler)this.outputfCap2.getNullable()).fill(out, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                this.tank[1].drain(drained, IFluidHandler.FluidAction.EXECUTE);
                out.shrink(accepted);
                update |= true;
            }
        }
        if (!((ItemStack)this.inventory.get(4)).func_190926_b() && this.field_145850_b.func_82737_E() % 8L == 0L) {
            ItemStack stack;
            boolean succeed = false;
            if (this.outputCap1.isPresent()) {
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(4)), (int)1);
                if ((stack = Utils.insertStackIntoInventory(this.outputCap1, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                    ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                    succeed = true;
                    if (((ItemStack)this.inventory.get(4)).func_190916_E() <= 0) {
                        this.inventory.set(4, (Object)ItemStack.field_190927_a);
                    }
                }
            }
            if (!succeed && this.outputCap2.isPresent()) {
                stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(4)), (int)1);
                if ((stack = Utils.insertStackIntoInventory(this.outputCap2, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                    ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(4)).func_190916_E() <= 0) {
                        this.inventory.set(4, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    public boolean hasElectrodes() {
        for (int i = 2; i < 4; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ElectrolyzerRecipe getRecipe() {
        ElectrolyzerRecipe recipe = ElectrolyzerRecipe.findRecipe((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1), this.tank[0].getFluid(), true);
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(4)).func_190926_b() || ItemStack.func_179545_c((ItemStack)((ItemStack)this.inventory.get(4)), (ItemStack)recipe.output) && ((ItemStack)this.inventory.get(4)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(4)) {
            return recipe;
        }
        return null;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (facing != null && facing.func_96559_d() == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177958_n() != 1 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.func_177952_p() == 1) {
                return this.inHandler.cast();
            }
            if (this.posInMultiblock.func_177952_p() == 3) {
                return this.outHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos bp = this.func_174877_v();
        if (!this.isDummy()) {
            return new AxisAlignedBB((double)(bp.func_177958_n() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 1)), (double)(bp.func_177956_o() - 1), (double)(bp.func_177952_p() - (this.getFacing().func_176740_k() == Direction.Axis.X ? 2 : 1)), (double)(bp.func_177958_n() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 2)), (double)(bp.func_177956_o() + 2), (double)(bp.func_177952_p() + (this.getFacing().func_176740_k() == Direction.Axis.X ? 3 : 2)));
        }
        return new AxisAlignedBB(bp);
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        if (this.master() != null) {
            return ((IndustrialElectrolyzerTileEntity)this.master()).inventory;
        }
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        if (this.master() == null) {
            return false;
        }
        ItemStack s0 = (ItemStack)((IndustrialElectrolyzerTileEntity)this.master()).inventory.get(0);
        ItemStack s1 = (ItemStack)((IndustrialElectrolyzerTileEntity)this.master()).inventory.get(1);
        if (slot == 0) {
            return stack.func_77969_a(s0) || !stack.func_77969_a(s1) && ElectrolyzerRecipe.isValidRecipeInput(stack);
        }
        if (slot == 1) {
            return stack.func_77969_a(s1) || !stack.func_77969_a(s0) && ElectrolyzerRecipe.isValidRecipeInput(stack);
        }
        return false;
    }

    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Nonnull
    public FluxStorage getFluxStorage() {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        return master != null ? master.energyStorage : this.energyStorage;
    }

    public boolean isEnergyPos() {
        return this.getEnergyPos().contains(this.posInMultiblock);
    }

    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(1, 1, 0));
    }

    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 1, 4));
    }

    @Nullable
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        return this.formed && this.isEnergyPos() ? this.wrapper : null;
    }

    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        if (!simulate) {
            this.updateMasterBlock(null, energy != 0);
        }
    }

    @Nullable
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
    }

    public int[] getCurrentProcessesStep() {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        IndustrialElectrolyzerTileEntity master = (IndustrialElectrolyzerTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }
}

