/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerBlock;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ElectrolyzerTileEntity
extends IEBaseTileEntity
implements IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
ITickableTileEntity,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IInteractionObjectIE {
    public int process = 0;
    public int processMax = 0;
    public int tickEnergy = 0;
    public ItemStack result = ItemStack.field_190927_a;
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(20000);
    public FluidTank tank = new FluidTank(8000, ElectrolyzerRecipe::isValidRecipeFluid);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public LazyOptional<IFluidHandler> fluidHandler = this.registerConstantCap(new FluidHandler(this));
    LazyOptional<IItemHandler> invHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true}));
    EnergyHelper.IEForgeEnergyWrapper wrapper = null;

    public ElectrolyzerTileEntity() {
        super((TileEntityType)IIContent.IITileTypes.ELECTROLYZER.get());
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        if (!descPacket) {
            this.result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("result"));
            this.tickEnergy = nbt.func_74762_e("tickEnergy");
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        if (!descPacket) {
            nbt.func_218657_a("result", (INBT)this.result.serializeNBT());
            nbt.func_74768_a("tickEnergy", this.tickEnergy);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStorage.getEnergyStored() >= this.tickEnergy) {
                ElectrolyzerRecipe recipe;
                if (this.process > 0) {
                    --this.process;
                    this.energyStorage.extractEnergy(this.tickEnergy, false);
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                if (!this.result.func_190926_b()) {
                    if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.inventory.set(1, (Object)this.result);
                        this.result = ItemStack.field_190927_a;
                        this.processMax = 0;
                        this.process = 0;
                        this.tickEnergy = 0;
                    } else if (((ItemStack)this.inventory.get(1)).func_77969_a(this.result)) {
                        ((ItemStack)this.inventory.get(1)).func_190917_f(this.result.func_190916_E());
                        this.result = ItemStack.field_190927_a;
                        this.processMax = 0;
                        this.process = 0;
                        this.tickEnergy = 0;
                    } else {
                        return;
                    }
                }
                if ((recipe = this.getRecipe()) != null) {
                    this.processMax = this.process = recipe.time;
                    this.tickEnergy = recipe.tickEnergy;
                    if (recipe.inputs.length > 0) {
                        Utils.modifyInvStackSize(this.inventory, (int)0, (int)(-recipe.inputs[0].getCount()));
                    }
                    if (recipe.input_fluid != null) {
                        this.tank.drain(recipe.input_fluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.result = recipe.output.func_77946_l();
                }
            } else if (this.process > 0) {
                this.process = this.processMax;
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Nullable
    public ElectrolyzerRecipe getRecipe() {
        ElectrolyzerRecipe recipe = ElectrolyzerRecipe.findRecipe((ItemStack)this.inventory.get(0), ItemStack.field_190927_a, this.tank.getFluid(), false);
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b() || ItemStack.func_179545_c((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)recipe.output) && ((ItemStack)this.inventory.get(1)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(1)) {
            return recipe;
        }
        return null;
    }

    public int[] getCurrentProcessesStep() {
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        return new int[]{this.processMax};
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (facing != null && facing.func_176740_k() != this.getFacing().func_176746_e().func_176740_k()) {
            if (facing != Direction.UP && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluidHandler.cast();
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.invHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return facing != this.getFacing().func_176746_e() ? IEEnums.IOSideConfig.NONE : IEEnums.IOSideConfig.INPUT;
    }

    @Nullable
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing != this.getFacing().func_176746_e()) {
            return null;
        }
        if (this.wrapper == null) {
            this.wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, this.getFacing().func_176746_e());
        }
        return this.wrapper;
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
    }

    public Property<Direction> getFacingProperty() {
        return ElectrolyzerBlock.FACING;
    }

    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.PISTON_LIKE;
    }

    @Nullable
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    static class FluidHandler
    implements IFluidHandler {
        ElectrolyzerTileEntity tile;

        @Nullable
        FluidHandler(ElectrolyzerTileEntity tile) {
            this.tile = tile;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource == null) {
                return 0;
            }
            int i = this.tile.tank.fill(resource, doFill);
            if (i > 0) {
                this.tile.func_70296_d();
                this.tile.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (resource == null) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            FluidStack f = this.tile.tank.drain(maxDrain, doDrain);
            if (!f.isEmpty()) {
                this.tile.func_70296_d();
                this.tile.markContainingBlockForUpdate(null);
            }
            return f;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tile.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.tile.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tile.tank.isFluidValid(tank, stack);
        }
    }
}

