/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ElectrolyzerRecipeSerializer
extends IERecipeSerializer<ElectrolyzerRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IIContent.IIBlocks.electrolyzer);
    }

    public ElectrolyzerRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        IngredientWithSize[] inputs;
        ItemStack output = this.readOutput(json.get("result"));
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = json.has("input") ? new IngredientWithSize[]{IngredientWithSize.deserialize((JsonElement)json.get("input"))} : new IngredientWithSize[]{};
        }
        FluidTagInput input_fluid = null;
        if (json.has("fluid")) {
            input_fluid = FluidTagInput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"fluid"));
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = (Integer)IIConfig.COMMON.electrolyzerBase.get();
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        boolean flag = JSONUtils.func_151209_a((JsonObject)json, (String)"large_only", (boolean)false);
        FluidStack result_fluid = null;
        if (json.has("result_fluid")) {
            result_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result_fluid"));
        }
        return new ElectrolyzerRecipe(recipeId, output, inputs, input_fluid, result_fluid, time, tickEnergy, flag);
    }

    @Nullable
    public ElectrolyzerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack output = buffer.func_150791_c();
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((PacketBuffer)buffer);
        }
        FluidTagInput input_fluid = null;
        FluidStack output_fluid = null;
        if (buffer.readBoolean()) {
            input_fluid = FluidTagInput.read((PacketBuffer)buffer);
        }
        if (buffer.readBoolean()) {
            output_fluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        }
        int time = buffer.func_150792_a();
        int tickEnergy = buffer.func_150792_a();
        boolean flag = buffer.readBoolean();
        return new ElectrolyzerRecipe(recipeId, output, inputs, input_fluid, output_fluid, time, tickEnergy, flag);
    }

    public void write(PacketBuffer buffer, ElectrolyzerRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        buffer.func_150787_b(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        if (recipe.input_fluid != null) {
            buffer.writeBoolean(true);
            recipe.input_fluid.write(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (recipe.output_fluid != null) {
            buffer.writeBoolean(true);
            recipe.output_fluid.writeToPacket(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.func_150787_b(recipe.time);
        buffer.func_150787_b(recipe.tickEnergy);
        buffer.writeBoolean(recipe.flag);
    }
}

