/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.IActiveState;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CrucibleTileEntity
extends MultiblockPartTileEntity<CrucibleTileEntity>
implements IIEInventory,
IActiveState,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IBlockBounds {
    public CrucibleData guiData = new CrucibleData();
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int temperature;
    public int burnTime;
    public int process = 0;
    public int processMax = 0;
    public int updatetick = 0;
    public static ResourceLocation coal_coke = new ResourceLocation("forge:coal_coke");
    LazyOptional<IItemHandler> inputHandler = this.registerConstantCap(new IEInventoryHandler(2, (IIEInventory)this, 0, true, false));
    LazyOptional<IItemHandler> fuelHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 2, true, false));
    LazyOptional<IItemHandler> outputHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 3, false, true));

    public CrucibleTileEntity() {
        super(IIContent.IIMultiblocks.CRUCIBLE, (TileEntityType)IIContent.IITileTypes.CRUCIBLE.get(), false);
    }

    @Nonnull
    public IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    public boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return false;
    }

    public boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Nullable
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    public int[] getCurrentProcessesStep() {
        CrucibleTileEntity master = (CrucibleTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        CrucibleTileEntity master = (CrucibleTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        CrucibleTileEntity master = (CrucibleTileEntity)this.master();
        if (master != null && master.formed && this.formed) {
            return master.inventory;
        }
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0 || slot == 1) {
            return CrucibleRecipe.isValidInput(stack);
        }
        if (slot == 2) {
            return stack.func_77973_b().getTags().contains(coal_coke);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        CrucibleTileEntity master;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (CrucibleTileEntity)this.master()) != null) {
            if (this.posInMultiblock.func_177956_o() <= 1) {
                return master.fuelHandler.cast();
            }
            if (facing == Direction.UP) {
                return master.inputHandler.cast();
            }
            return master.outputHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.temperature = nbt.func_74762_e("temperature");
        this.burnTime = nbt.func_74762_e("burntime");
        if (!descPacket) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
            this.process = nbt.func_74762_e("process");
            this.processMax = nbt.func_74762_e("processMax");
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("temperature", this.temperature);
        nbt.func_74768_a("burntime", this.burnTime);
        if (!descPacket) {
            nbt.func_74768_a("process", this.process);
            nbt.func_74768_a("processMax", this.processMax);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.isDummy()) {
            Random random;
            int i;
            if (!this.field_145850_b.field_72995_K && this.formed) {
                CrucibleRecipe recipe = this.getRecipe();
                ++this.updatetick;
                if (this.updatetick > 10) {
                    boolean activeAfterTick;
                    boolean activeBeforeTick = this.getIsActive();
                    if (this.temperature > 0) {
                        this.updatetick = 0;
                        this.markContainingBlockForUpdate(null);
                        if (!activeBeforeTick) {
                            this.setActive(true);
                        }
                    } else if (activeBeforeTick) {
                        this.setActive(false);
                    }
                    if (activeBeforeTick != (activeAfterTick = this.getIsActive())) {
                        ((CrucibleTileEntity)this.master()).func_70296_d();
                        for (int x = 0; x < 3; ++x) {
                            for (int y = 0; y < 4; ++y) {
                                for (int z = 0; z < 3; ++z) {
                                    BlockPos actualPos = this.getBlockPosForPos(new BlockPos(x, y, z));
                                    TileEntity te = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)actualPos);
                                    if (!(te instanceof CrucibleTileEntity)) continue;
                                    ((CrucibleTileEntity)te).setActive(activeAfterTick);
                                }
                            }
                        }
                    }
                }
                if (this.burnTime > 0) {
                    if (this.getFromPreheater(BlastFurnacePreheaterTileEntity::doSpeedup, 0) > 0) {
                        if (this.temperature < 1680) {
                            ++this.temperature;
                        }
                    } else if (this.temperature < 1100) {
                        ++this.temperature;
                    } else if (this.temperature > 1100) {
                        --this.temperature;
                    }
                } else if (this.temperature > 0) {
                    --this.temperature;
                }
                if (this.burnTime > 0) {
                    --this.burnTime;
                } else if (!((ItemStack)this.inventory.get(2)).func_190926_b() && ((ItemStack)this.inventory.get(2)).func_77973_b().getTags().contains(coal_coke)) {
                    this.burnTime = (Integer)IIConfig.COMMON.coke.get();
                    ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                    ((CrucibleTileEntity)this.master()).func_70296_d();
                }
                if (this.temperature > 1400) {
                    if (this.process > 0) {
                        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
                            this.process = 0;
                            this.processMax = 0;
                        } else if (recipe == null || recipe.time != this.processMax) {
                            this.process = 0;
                            this.processMax = 0;
                        } else {
                            --this.process;
                            this.getFromPreheater(BlastFurnacePreheaterTileEntity::doSpeedup, 0);
                        }
                        this.markContainingBlockForUpdate(null);
                    } else if (recipe != null) {
                        if (this.processMax == 0) {
                            this.processMax = this.process = recipe.time;
                        } else {
                            if (recipe.inputs.length > 0) {
                                for (i = 0; i < recipe.inputs.length; ++i) {
                                    Utils.modifyInvStackSize(this.inventory, (int)i, (int)(-recipe.inputs[i].getCount()));
                                }
                            }
                            if (!((ItemStack)this.inventory.get(3)).func_190926_b()) {
                                ((ItemStack)this.inventory.get(3)).func_190917_f(recipe.output.func_77946_l().func_190916_E());
                            } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                                this.inventory.set(3, (Object)recipe.output.func_77946_l());
                            }
                            this.processMax = 0;
                        }
                    }
                }
            }
            if (this.field_145850_b != null && this.formed && this.getIsActive() && (random = this.field_145850_b.field_73012_v).nextFloat() < 0.4f) {
                for (i = 0; i < random.nextInt(2) + 2; ++i) {
                    this.field_145850_b.func_217404_b((IParticleData)ParticleTypes.field_218418_af, true, (double)this.field_174879_c.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.field_174879_c.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)this.field_174879_c.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.05, 0.0);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.field_174879_c.func_177956_o() + 0.4, (double)this.field_174879_c.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.002, 0.01, 0.0);
                }
            }
        }
    }

    @Nullable
    public CrucibleRecipe getRecipe() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return null;
        }
        CrucibleRecipe recipe = CrucibleRecipe.findRecipe((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(3)).func_190926_b() || ItemStack.func_179545_c((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)recipe.output) && ((ItemStack)this.inventory.get(3)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(3)) {
            return recipe;
        }
        return null;
    }

    public <V> V getFromPreheater(Function<BlastFurnacePreheaterTileEntity, V> getter, V orElse) {
        return this.getBlast().map(getter).orElse(orElse);
    }

    public Optional<BlastFurnacePreheaterTileEntity> getBlast() {
        BlockPos pos = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(this.getFacing(), 2);
        TileEntity te = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)pos);
        if (te instanceof BlastFurnacePreheaterTileEntity && ((BlastFurnacePreheaterTileEntity)te).getFacing().equals((Object)this.getFacing().func_176734_d())) {
            return Optional.of((BlastFurnacePreheaterTileEntity)te);
        }
        return Optional.empty();
    }

    public class CrucibleData
    implements IIntArray {
        public static final int BURN_TIME = 0;
        public static final int PROCESS_MAX = 1;
        public static final int CURRENT_PROCESS = 2;

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CrucibleTileEntity.this.burnTime;
                }
                case 1: {
                    return CrucibleTileEntity.this.processMax;
                }
                case 2: {
                    return CrucibleTileEntity.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CrucibleTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    CrucibleTileEntity.this.processMax = value;
                    break;
                }
                case 2: {
                    CrucibleTileEntity.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    }
}

