/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class CrucibleRecipeSerializer
extends IERecipeSerializer<CrucibleRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IIContent.IIMultiblocks.crucible);
    }

    public CrucibleRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        IngredientWithSize[] inputs;
        ItemStack output = this.readOutput(json.get("result"));
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = new IngredientWithSize[]{};
        }
        int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
        if (inputs == null || inputs.length == 0) {
            throw new RuntimeException("Error loading crucible recipe " + recipeId);
        }
        return new CrucibleRecipe(recipeId, output, inputs, time);
    }

    @Nullable
    public CrucibleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack output = buffer.func_150791_c();
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((PacketBuffer)buffer);
        }
        int time = buffer.readInt();
        return new CrucibleRecipe(recipeId, output, inputs, time);
    }

    public void write(PacketBuffer buffer, CrucibleRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        buffer.func_150787_b(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        buffer.writeInt(recipe.time);
    }
}

