/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.carkiln;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRecipe;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CarKilnRecipeSerializer
extends IERecipeSerializer<CarKilnRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IIContent.IIMultiblocks.car_kiln);
    }

    public CarKilnRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        IngredientWithSize[] inputs;
        ItemStack[] output;
        if (json.has("results")) {
            JsonArray ja = json.get("results").getAsJsonArray();
            ArrayList<ItemStack> ops = new ArrayList<ItemStack>();
            for (Object je : ja) {
                ops.add(this.readOutput((JsonElement)je));
            }
            output = ops.toArray(new ItemStack[0]);
        } else {
            output = new ItemStack[]{this.readOutput(json.get("result"))};
        }
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = json.has("input") ? new IngredientWithSize[]{IngredientWithSize.deserialize((JsonElement)json.get("input"))} : new IngredientWithSize[]{};
        }
        FluidStack input_fluid = FluidStack.EMPTY;
        if (json.has("input_fluid")) {
            input_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = (Integer)IIConfig.COMMON.carKilnBase.get();
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        int start_fluid_cost = 0;
        if (json.has("start_fluid_cost")) {
            start_fluid_cost = json.get("start_fluid_cost").getAsInt();
        }
        return new CarKilnRecipe(recipeId, output, inputs, input_fluid, time, tickEnergy, start_fluid_cost);
    }

    @Nullable
    public CarKilnRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        int outs = buffer.func_150792_a();
        ItemStack[] output = new ItemStack[outs];
        for (int i = 0; i < outs; ++i) {
            output[i] = buffer.func_150791_c();
        }
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((PacketBuffer)buffer);
        }
        return new CarKilnRecipe(recipeId, output, inputs, FluidStack.readFromPacket((PacketBuffer)buffer), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }

    public void write(PacketBuffer buffer, CarKilnRecipe recipe) {
        buffer.func_150787_b(recipe.output.length);
        for (int i = 0; i < recipe.output.length; ++i) {
            buffer.func_150788_a(recipe.output[i]);
        }
        buffer.func_150787_b(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        recipe.input_fluid.writeToPacket(buffer);
        buffer.func_150787_b(recipe.time);
        buffer.func_150787_b(recipe.tickEnergy);
        buffer.func_150787_b(recipe.start_fluid_cost);
    }
}

