/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.common.gui.GuiHandler;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnRenderer;
import com.teammoeg.immersiveindustry.content.carkiln.CarKilnScreen;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerRenderer;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerScreen;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRenderer;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="immersiveindustry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistryEvents {
    private static Tree.InnerNode<ResourceLocation, ManualEntry> CATEGORY;
    public static final Map<String, Supplier<Object>> extras;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistryEvents.registerIEScreen(new ResourceLocation("immersiveindustry", "crucible"), CrucibleScreen::new);
        ClientRegistryEvents.registerIEScreen(new ResourceLocation("immersiveindustry", "electrolyzer"), ElectrolyzerScreen::new);
        ClientRegistryEvents.registerIEScreen(new ResourceLocation("immersiveindustry", "industrial_electrolyzer"), IndustrialElectrolyzerScreen::new);
        ClientRegistryEvents.registerIEScreen(new ResourceLocation("immersiveindustry", "car_kiln"), CarKilnScreen::new);
        ClientRegistryEvents.registerIEScreen(new ResourceLocation("immersiveindustry", "rotary_kiln"), RotaryKilnScreen::new);
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIMultiblocks.crucible, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIMultiblocks.steam_turbine, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIBlocks.electrolyzer, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIMultiblocks.industrial_electrolyzer, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIMultiblocks.rotary_kiln, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)IIContent.IIMultiblocks.car_kiln, (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IIContent.IITileTypes.IND_ELE.get()), IndustrialElectrolyzerRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IIContent.IITileTypes.ROTARY_KILN.get()), RotaryKilnRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IIContent.IITileTypes.CAR_KILN.get()), CarKilnRenderer::new);
        ClientRegistryEvents.addManual();
    }

    public static <C extends Container, S extends Screen> void registerIEScreen(ResourceLocation containerName, ScreenManager.IScreenFactory<C, S> factory) {
        ContainerType type = GuiHandler.getContainerType((ResourceLocation)containerName);
        ScreenManager.func_216911_a((ContainerType)type, factory);
    }

    public static void addManual() {
        ManualInstance man = ManualHelper.getManual();
        CATEGORY = man.getRoot().getOrCreateSubnode((Comparable)new ResourceLocation("immersiveindustry", "main"), 100);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("crucible", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.CRUCIBLE));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "crucible"));
        man.addEntry(CATEGORY, builder.create(), 0);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.readFromFile(new ResourceLocation("immersiveindustry", "electrolyzer"));
        man.addEntry(CATEGORY, builder.create(), 1);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("industrial_electrolyzer", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.IND_ELE));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "industrial_electrolyzer"));
        man.addEntry(CATEGORY, builder.create(), 2);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("car_kiln", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.CAR_KILN));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "car_kiln"));
        man.addEntry(CATEGORY, builder.create(), 3);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("rotary_kiln", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.ROTARY_KILN));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "rotary_kiln"));
        man.addEntry(CATEGORY, builder.create(), 4);
        builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement("steam_turbine", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)IIContent.IIMultiblocks.STEAMTURBINE));
        builder.readFromFile(new ResourceLocation("immersiveindustry", "steam_turbine"));
        man.addEntry(CATEGORY, builder.create(), 5);
        extras.put("steamTurbineGenerator", () -> IIConfig.COMMON.steamTurbineGenerator.get());
        extras.put("electrodeCost", () -> IIConfig.COMMON.electrodeCost.get());
        ((Consumer)ManualHelper.ADD_CONFIG_GETTER.getValue()).accept(s -> {
            String path;
            if (s.startsWith("immersiveindustry") && extras.containsKey(path = s.substring(s.indexOf(".") + 1))) {
                return extras.get(path).get();
            }
            return null;
        });
    }

    static {
        extras = new HashMap<String, Supplier<Object>>();
    }
}

