/*
 * Decompiled with CFR 0.152.
 */
package com.mrcyberdragon.artronconverters.tileentities;

import com.mrcyberdragon.artronconverters.config.ArtronConverterConfig;
import com.mrcyberdragon.artronconverters.init.ModEnergy;
import com.mrcyberdragon.artronconverters.init.SoundInit;
import com.mrcyberdragon.artronconverters.init.TileEntityInit;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.ArtronUse;

public class TileEntityArtronConverter
extends TileEntity
implements ITickableTileEntity {
    private int Buffer = (Integer)ArtronConverterConfig.converter_capacity.get();
    private int GenerationRate = (Integer)ArtronConverterConfig.converter_generation.get();
    private ModEnergy energy = new ModEnergy(this.Buffer, this.GenerationRate, this.Buffer);
    private LazyOptional<EnergyStorage> energyHolder = LazyOptional.of(() -> this.energy);
    private int tick = 7;
    private long time1 = 0L;
    private long time2 = 0L;
    private boolean energyFull = false;
    private boolean spawnParticle = false;
    private String TARDIS_ID;
    private String TARDIS_NAME;
    private ConsoleTile tile;

    public TileEntityArtronConverter() {
        super((TileEntityType)TileEntityInit.ARTRON_CONVERTER.get());
    }

    public void func_73660_a() {
        this.getCapability(CapabilityEnergy.ENERGY).ifPresent(cap -> {
            if (this.tile == null) {
                return;
            }
            if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
                if (0 < this.tick) {
                    --this.tick;
                }
                if (this.tick == 7) {
                    this.time1 = this.field_145850_b.func_82737_E();
                }
                if (this.tick == 0) {
                    this.time2 = this.field_145850_b.func_82737_E();
                    this.tick = 7;
                }
                if (this.tile != null && this.tile.getArtron() > 1.0f && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored() - this.GenerationRate) {
                    if (this.TARDIS_ID != null && this.TARDIS_ID.equals(this.tile.func_145831_w().func_234923_W_().func_240901_a_().toString())) {
                        cap.receiveEnergy(this.GenerationRate, false);
                        ArtronUse use = this.tile.getOrCreateArtronUse((ArtronUse.IArtronType)ArtronUse.ArtronType.CONVERTER);
                        use.setArtronUsePerTick(1.0f);
                        use.setTicksToDrain(1);
                        this.spawnParticle = true;
                        if (this.time2 - this.time1 > 6L) {
                            this.time1 = 0L;
                            this.time2 = 0L;
                            if (!this.field_145850_b.func_201670_d()) {
                                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundInit.ARTRON_GEN, SoundCategory.BLOCKS, 0.75f, 1.0f);
                            }
                            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                        }
                    }
                } else {
                    if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                        this.energyFull = false;
                    }
                    if (this.tick == 0 && !this.energyFull) {
                        if (this.energy.getEnergyStored() == this.energy.getMaxEnergyStored()) {
                            this.energyFull = true;
                        }
                        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                        this.spawnParticle = false;
                    }
                }
                for (Direction dir : Direction.values()) {
                    TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
                    if (te == null) continue;
                    te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()).ifPresent(power -> {
                        if (cap.getEnergyStored() >= this.GenerationRate) {
                            cap.extractEnergy(power.receiveEnergy(this.GenerationRate, false), false);
                        }
                    });
                }
            } else {
                if (0 < this.tick && this.tick <= 7) {
                    --this.tick;
                }
                if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                    this.energyFull = false;
                }
                if (this.tick == 0) {
                    if (!this.energyFull) {
                        if (this.energy.getEnergyStored() == this.energy.getMaxEnergyStored()) {
                            this.energyFull = true;
                        }
                        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                        this.spawnParticle = false;
                    }
                    this.tick = 7;
                }
            }
        });
        if (this.tile == null || this.tile.func_145837_r()) {
            TardisHelper.getConsoleInWorld((World)this.field_145850_b).ifPresent(console -> {
                this.tile = console;
            });
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("particle", this.spawnParticle);
        compound.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        if (this.TARDIS_ID != null) {
            compound.func_74778_a("attuned_console", this.TARDIS_ID);
        }
        if (this.TARDIS_NAME != null) {
            compound.func_74778_a("tardis_name", this.TARDIS_NAME);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.energy.deserializeNBT(nbt.func_74775_l("energy"));
        this.spawnParticle = nbt.func_74767_n("particle");
        this.TARDIS_ID = nbt.func_74779_i("attuned_console");
        this.TARDIS_NAME = nbt.func_74779_i("tardis_name");
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (this.TARDIS_ID != null) {
            compound.func_74778_a("attuned_console", this.TARDIS_ID);
        }
        if (this.TARDIS_NAME != null) {
            compound.func_74778_a("tardis_name", this.TARDIS_NAME);
        }
        return compound;
    }

    public CompoundNBT loadFromNBT(CompoundNBT nbt) {
        this.TARDIS_ID = nbt.func_74779_i("attuned_console");
        this.TARDIS_NAME = nbt.func_74779_i("tardis_name");
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        Random random = new Random();
        if (this.spawnParticle) {
            for (int i = 5; i > 0; --i) {
                this.field_145850_b.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)((float)this.func_174877_v().func_177958_n() + random.nextFloat()), (double)((float)this.func_174877_v().func_177956_o() + random.nextFloat()), (double)((float)this.func_174877_v().func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityEnergy.ENERGY ? this.energyHolder.cast() : super.getCapability(cap, side);
    }
}

