/*
 * Decompiled with CFR 0.152.
 */
package com.mrcyberdragon.artronconverters.tileentities;

import com.mrcyberdragon.artronconverters.config.ArtronConverterConfig;
import com.mrcyberdragon.artronconverters.init.ModEnergy;
import com.mrcyberdragon.artronconverters.init.SoundInit;
import com.mrcyberdragon.artronconverters.init.TileEntityInit;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.tardis.mod.artron.IArtronHolder;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.network.Network;
import net.tardis.mod.particles.TParticleTypes;
import net.tardis.mod.sounds.TSounds;

public class TileEntityArtronCharger
extends TileEntity
implements ITickableTileEntity,
IArtronHolder {
    private float artron = 0.0f;
    private float maxartron = ((Float)ArtronConverterConfig.charger_max_artron.get()).floatValue();
    private float chargerate = ((Float)ArtronConverterConfig.charger_rate.get()).floatValue();
    private int EnergyCapacity = (Integer)ArtronConverterConfig.charger_capacity.get();
    private int fillRate = (Integer)ArtronConverterConfig.charger_charge.get();
    private int ConversionAmount = (Integer)ArtronConverterConfig.charger_usage.get();
    private ModEnergy energy = new ModEnergy(this.EnergyCapacity, this.fillRate, this.EnergyCapacity);
    private LazyOptional<EnergyStorage> energyHolder = LazyOptional.of(() -> this.energy);
    ItemStack stack = ItemStack.field_190927_a;
    private int particleSpawnTimer = 100;
    private boolean hasSpawnedInitialParticle = false;
    private boolean tick = false;
    private boolean energyfull = false;
    private boolean artronfull = false;

    public TileEntityArtronCharger() {
        super((TileEntityType)TileEntityInit.ARTRON_CHARGER.get());
    }

    public void func_73660_a() {
        this.tick = this.field_145850_b.func_82737_E() % 7L == 0L;
        if (this.getItem().func_190926_b()) {
            this.hasSpawnedInitialParticle = false;
        }
        if (!this.getItem().func_190926_b() && this.field_145850_b.func_201670_d()) {
            if (!this.hasSpawnedInitialParticle) {
                this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.BUBBLE.get(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.hasSpawnedInitialParticle = true;
            }
            if (this.particleSpawnTimer > 0) {
                --this.particleSpawnTimer;
            }
            if (this.particleSpawnTimer == 7) {
                this.field_145850_b.func_195594_a((IParticleData)TParticleTypes.BUBBLE.get(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.resetParticleSpawnTimer();
            }
        }
        this.getCapability(CapabilityEnergy.ENERGY).ifPresent(cap -> {
            if (!this.field_145850_b.field_72995_K) {
                if (this.getArtron() < this.maxartron) {
                    if (this.energy.getEnergyStored() >= this.ConversionAmount) {
                        this.tick = true;
                        if (true) {
                            this.recieveArtron(1.0f);
                            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                            this.energy.extractEnergy(this.ConversionAmount, false);
                            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundInit.ARTRON_GEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                } else if (!this.artronfull && this.getArtron() == this.maxartron) {
                    this.artronfull = true;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                } else if (this.tick && this.getArtron() < this.maxartron) {
                    this.artronfull = false;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                }
                if (!this.energyfull && this.energy.getEnergyStored() == this.energy.getMaxEnergyStored()) {
                    this.energyfull = true;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                } else if (this.tick && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                    this.energyfull = false;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                }
                if (this.getItem().func_77973_b() instanceof IArtronItemStackBattery && this.field_145850_b.func_82737_E() % 20L == 0L && this.getArtron() >= this.chargerate && ((IArtronItemStackBattery)this.getItem().func_77973_b()).getCharge(this.getItem()) < ((IArtronItemStackBattery)this.getItem().func_77973_b()).getMaxCharge(this.getItem())) {
                    float artronUse = this.takeArtron(this.chargerate);
                    ((IArtronItemStackBattery)this.getItem().func_77973_b()).charge(this.getItem(), artronUse / 2.0f);
                    if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)TSounds.ELECTRIC_ARC.get(), SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    this.func_70296_d();
                }
            }
        });
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("item")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item"));
        }
        this.artron = compound.func_74760_g("artron");
        this.energy.deserializeNBT(compound.func_74775_l("energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("item", (INBT)this.stack.serializeNBT());
        compound.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        compound.func_74776_a("artron", this.artron);
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return Network.createTEUpdatePacket((TileEntity)this);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public float getArtron() {
        return this.artron;
    }

    public float recieveArtron(float amount) {
        this.artron += amount;
        return amount;
    }

    public float takeArtron(float amt) {
        if (this.artron >= amt) {
            this.artron -= amt;
            return amt;
        }
        float oldArtron = this.artron;
        this.artron = 0.0f;
        return oldArtron;
    }

    public void placeItem(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public void resetParticleSpawnTimer() {
        this.particleSpawnTimer = 100;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityEnergy.ENERGY && (side == Direction.DOWN || side == null) ? this.energyHolder.cast() : super.getCapability(cap, side);
    }
}

