/*
 * Decompiled with CFR 0.152.
 */
package com.mrcyberdragon.artronconverters;

import com.mrcyberdragon.artronconverters.config.ArtronConverterConfig;
import com.mrcyberdragon.artronconverters.init.BlockInit;
import com.mrcyberdragon.artronconverters.init.ItemInit;
import com.mrcyberdragon.artronconverters.init.SoundRegistry;
import com.mrcyberdragon.artronconverters.init.TileEntityInit;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="artrongen")
public class ArtronConverters {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "artrongen";

    public ArtronConverters() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        BlockInit.BLOCKS.register(bus);
        ItemInit.ITEMS.register(bus);
        TileEntityInit.TILES.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SoundRegistry());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ArtronConverterConfig.SPEC, "artrongen-config.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        int EnergyCapacity = (Integer)ArtronConverterConfig.generator_capacity.get();
        int ConversionAmount = (Integer)ArtronConverterConfig.generator_usage.get();
        int ChargeRate = (Integer)ArtronConverterConfig.generator_charge.get();
        int GenRate = (Integer)ArtronConverterConfig.converter_generation.get();
        int GenBuffer = (Integer)ArtronConverterConfig.converter_capacity.get();
        int ChargerCapacity = (Integer)ArtronConverterConfig.charger_capacity.get();
        int ChargerMaxFE = (Integer)ArtronConverterConfig.charger_charge.get();
        int ChargerConversion = (Integer)ArtronConverterConfig.charger_usage.get();
        float ChargerAU = ((Float)ArtronConverterConfig.charger_max_artron.get()).floatValue();
        float ChargingRate = ((Float)ArtronConverterConfig.charger_rate.get()).floatValue();
        if (ConversionAmount > EnergyCapacity) {
            throw new IllegalArgumentException("Config Error! Energy buffer must be greater than or equal to conversion/usage rate!");
        }
        if (ChargerConversion > ChargerCapacity) {
            throw new IllegalArgumentException("Config Error! Energy buffer must be greater than or equal to conversion/usage rate!");
        }
        if (GenRate > GenBuffer) {
            throw new IllegalArgumentException("Config Error! Energy buffer must be greater than or equal to generation rate!");
        }
        if (ChargingRate > ChargerAU) {
            throw new IllegalArgumentException("Config Error! Artron buffer must be be greater then or equal to Artron charge rate!");
        }
        if (EnergyCapacity <= 0 || ConversionAmount <= 0 || ChargeRate <= 0 || GenRate <= 0 || GenBuffer <= 0 || ChargerCapacity <= 0 || ChargerMaxFE <= 0 || ChargerConversion <= 0 || ChargerAU <= 0.0f || ChargingRate <= 0.0f) {
            throw new IllegalArgumentException("Config Error! Config values must be a positive integer or float!");
        }
    }
}

