/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityFusionReactorLogicAdapter
extends TileEntityFusionReactorBlock
implements IReactorLogic<FusionReactorLogic>,
IHasMode {
    public FusionReactorLogic logicType = FusionReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityFusionReactorLogicAdapter() {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER);
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            World world = this.func_145831_w();
            if (world != null) {
                world.func_195593_d(this.func_174877_v(), this.getBlockType());
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            switch (this.logicType) {
                case READY: {
                    return multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled);
                }
                case CAPACITY: {
                    return multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled);
                }
                case DEPLETED: {
                    return multiblock.deuteriumTank.getStored() < (long)(multiblock.getInjectionRate() / 2) || multiblock.tritiumTank.getStored() < (long)(multiblock.getInjectionRate() / 2);
                }
            }
            return false;
        }
        return false;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setEnumIfPresent((CompoundNBT)nbtTags, (String)"logicType", FusionReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.ordinal());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
        return nbtTags;
    }

    @Override
    public boolean canBeMaster() {
        return false;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markDirty(false);
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FusionReactorLogic getMode() {
        return this.logicType;
    }

    public FusionReactorLogic[] getModes() {
        return FusionReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FusionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markDirty(false);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FusionReactorLogic::byIndexStatic, (Enum)FusionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    private void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    public static enum FusionReactorLogic implements IReactorLogicMode<FusionReactorLogic>,
    IHasTranslationKey
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((IItemProvider)Items.field_151016_H)),
        READY(GeneratorsLang.REACTOR_LOGIC_READY, GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((IItemProvider)Items.field_151137_ax)),
        CAPACITY(GeneratorsLang.REACTOR_LOGIC_CAPACITY, GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((IItemProvider)Items.field_151137_ax)),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((IItemProvider)Items.field_151137_ax));

        private static final FusionReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;

        private FusionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public ITextComponent getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public static FusionReactorLogic byIndexStatic(int index) {
            return (FusionReactorLogic)MathUtils.getByIndexMod((Object[])MODES, (int)index);
        }

        static {
            MODES = FusionReactorLogic.values();
        }
    }
}

