/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class TileEntityFissionReactorCasing
extends TileEntityMultiblock<FissionReactorMultiblockData> {
    private boolean handleSound;
    private boolean prevBurning;

    public TileEntityFissionReactorCasing() {
        super(GeneratorsBlocks.FISSION_REACTOR_CASING);
    }

    public TileEntityFissionReactorCasing(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    protected boolean onUpdateServer(FissionReactorMultiblockData multiblock) {
        boolean burning;
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean bl = burning = multiblock.isFormed() && multiblock.handlesSound(this) && multiblock.isBurning();
        if (burning != this.prevBurning) {
            this.prevBurning = burning;
            needsPacket = true;
        }
        return needsPacket;
    }

    public double getBoilEfficiency() {
        return (double)Math.round(((FissionReactorMultiblockData)this.getMultiblock()).getBoilEfficiency() * 1000.0) / 1000.0;
    }

    public void setReactorActive(boolean active) {
        ((FissionReactorMultiblockData)this.getMultiblock()).setActive(active);
    }

    public ITextComponent getDamageString() {
        return MekanismLang.GENERIC_PERCENT.translate(new Object[]{((FissionReactorMultiblockData)this.getMultiblock()).getDamagePercent()});
    }

    public EnumColor getDamageColor() {
        double damage = ((FissionReactorMultiblockData)this.getMultiblock()).reactorDamage / 100.0;
        return damage < 0.25 ? EnumColor.BRIGHT_GREEN : (damage < 0.5 ? EnumColor.YELLOW : (damage < 0.75 ? EnumColor.ORANGE : EnumColor.DARK_RED));
    }

    public EnumColor getTempColor() {
        double temp = ((FissionReactorMultiblockData)this.getMultiblock()).heatCapacitor.getTemperature();
        return temp < 600.0 ? EnumColor.BRIGHT_GREEN : (temp < 1000.0 ? EnumColor.YELLOW : (temp < 1200.0 ? EnumColor.ORANGE : (temp < 1600.0 ? EnumColor.RED : EnumColor.DARK_RED)));
    }

    public void setRateLimitFromPacket(double rate) {
        ((FissionReactorMultiblockData)this.getMultiblock()).setRateLimit(rate);
    }

    public FissionReactorMultiblockData createMultiblock() {
        return new FissionReactorMultiblockData(this);
    }

    public MultiblockManager<FissionReactorMultiblockData> getManager() {
        return MekanismGenerators.fissionReactorManager;
    }

    protected boolean canPlaySound() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        return multiblock.isFormed() && multiblock.isBurning() && this.handleSound;
    }

    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        updateTag.func_74757_a("handleSound", multiblock.isFormed() && multiblock.handlesSound(this));
        if (multiblock.isFormed()) {
            updateTag.func_74780_a("burning", multiblock.lastBurnRate);
        }
        return updateTag;
    }

    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBooleanIfPresent((CompoundNBT)tag, (String)"handleSound", value -> {
            this.handleSound = value;
        });
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            NBTUtils.setDoubleIfPresent((CompoundNBT)tag, (String)"burning", value -> {
                multiblock.lastBurnRate = value;
            });
        }
    }
}

