/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBigLight;
import mekanism.client.gui.element.GuiGraph;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiHybridGauge;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiFissionReactor
extends GuiMekanismTile<TileEntityFissionReactorCasing, MekanismTileContainer<TileEntityFissionReactorCasing>> {
    private static final ResourceLocation JEI_LOCATION = MekanismGenerators.rl("fission");
    private TranslationButton activateButton;
    private TranslationButton scramButton;
    private GuiGraph heatGraph;

    public GuiFissionReactor(MekanismTileContainer<TileEntityFissionReactorCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 195;
        this.field_147000_g += 89;
        this.field_238744_r_ = 6;
        this.field_238745_s_ = this.field_147000_g - 92;
        this.field_238743_q_ = 5;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_((Widget)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.STAT));
        this.func_230480_a_((Widget)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.STATUS.translate(new Object[]{multiblock.isActive() ? EnumColor.BRIGHT_GREEN : EnumColor.RED, BooleanStateDisplay.ActiveDisabled.of((boolean)multiblock.isActive())}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{multiblock.lastBurnRate}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{TextUtils.format((long)multiblock.lastBoilRate)}), MekanismLang.TEMPERATURE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getTempColor(), MekanismUtils.getTemperatureDisplay((double)multiblock.heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getDamageColor(), ((TileEntityFissionReactorCasing)this.tile).getDamageString()}));
        }).spacing(2).jeiCategories(new ResourceLocation[]{JEI_LOCATION}));
        this.func_230480_a_((Widget)new GuiHybridGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).gasCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fluidCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 6, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fuelTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 25, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatedCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 152, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).wasteTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 171, 13).setLabel((ITextComponent)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
        this.func_230480_a_((Widget)new GuiHeatTab((IGuiWrapper)this, () -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        this.activateButton = (TranslationButton)this.func_230480_a_((Widget)new TranslationButton((IGuiWrapper)this, 6, 75, 81, 16, GeneratorsLang.FISSION_ACTIVATE, () -> MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (TileEntity)this.tile, 1.0)), null, () -> EnumColor.DARK_GREEN){

            public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
                super.renderForeground(matrix, mouseX, mouseY);
                if (!this.field_230693_o_ && ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)GuiFissionReactor.this.tile).getMultiblock()).isForceDisabled()) {
                    this.field_230693_o_ = true;
                    if (this.isMouseOverCheckWindows(mouseX, mouseY)) {
                        this.displayTooltip(matrix, (ITextComponent)GeneratorsLang.FISSION_FORCE_DISABLED.translate(new Object[0]), mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
                    }
                    this.field_230693_o_ = false;
                }
            }
        });
        this.scramButton = (TranslationButton)this.func_230480_a_((Widget)new TranslationButton((IGuiWrapper)this, 89, 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_SCRAM, () -> MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (TileEntity)this.tile, 0.0)), null, () -> EnumColor.DARK_RED));
        this.func_230480_a_((Widget)new GuiBigLight((IGuiWrapper)this, 173, 76, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock())::isActive));
        this.func_230480_a_((Widget)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature() / 1800.0);
            }
        }, 5, 102, this.field_146999_f - 12));
        this.heatGraph = (GuiGraph)this.func_230480_a_((Widget)new GuiGraph((IGuiWrapper)this, 5, 123, this.field_146999_f - 10, 38, temp -> MekanismUtils.getTemperatureDisplay((double)temp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)));
        this.heatGraph.setMinScale(1600L);
        this.updateButtons();
    }

    private void updateButtons() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.activateButton.field_230693_o_ = !multiblock.isActive() && !multiblock.isForceDisabled();
        this.scramButton.field_230693_o_ = multiblock.isActive();
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.updateButtons();
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), this.field_238743_q_);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.TEMPERATURE_LONG.translate(new Object[]{""}), 6, 93, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)GeneratorsLang.FISSION_HEAT_GRAPH.translate(new Object[0]), 6, 114, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.heatGraph.addData(MathUtils.clampToLong((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatCapacitor.getTemperature()));
    }
}

