/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LogicSupport {
    private int powerOutput = 0;

    public static LogicFacing getFacing(BlockState state) {
        return (LogicFacing)((Object)state.func_177229_b(LogicSlabBlock.LOGIC_FACING));
    }

    public void setPowerOutput(int powerOutput) {
        this.powerOutput = powerOutput;
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    public void setRedstoneState(GenericTileEntity te, int newout) {
        if (this.powerOutput == newout) {
            return;
        }
        this.powerOutput = newout;
        te.func_70296_d();
        BlockState state = te.func_195044_w();
        Direction outputSide = LogicSupport.getFacing(state).getInputSide().func_176734_d();
        te.func_145831_w().func_190524_a(te.func_174877_v().func_177972_a(outputSide), state.func_177230_c(), te.func_174877_v());
    }

    public void checkRedstone(GenericTileEntity te, World world, BlockPos pos) {
        Direction inputSide = LogicSupport.getFacing(world.func_180495_p(pos)).getInputSide();
        int power = this.getInputStrength(world, pos, inputSide);
        te.setPowerInput(power);
    }

    public int getInputStrength(World world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((Property)RedstoneWireBlock.field_176351_O));
        }
        return power;
    }

    public int getRedstoneOutput(BlockState state, Direction side) {
        if (side == LogicSupport.getFacing(state).getInputSide()) {
            return this.getPowerOutput();
        }
        return 0;
    }
}

