/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.compat.patchouli.PatchouliCompatibility;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketOpenManual {
    private ResourceLocation manual;
    private ResourceLocation entry;
    private int page;

    public PacketOpenManual(PacketBuffer buf) {
        this.manual = buf.func_192575_l();
        this.entry = buf.func_192575_l();
        this.page = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.manual);
        buf.func_192572_a(this.entry);
        buf.writeInt(this.page);
    }

    public PacketOpenManual(ResourceLocation manual, ResourceLocation entry, int page) {
        this.manual = manual;
        this.entry = entry;
        this.page = page;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketOpenManual.handle(this, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    private static void handle(PacketOpenManual message, NetworkEvent.Context ctx) {
        ServerPlayerEntity playerEntity = ctx.getSender();
        PatchouliCompatibility.openBookEntry(playerEntity, message.manual, message.entry, message.page);
    }
}

