/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AutomationFilterItemHander
implements IItemHandlerModifiable,
INBTSerializable<ListNBT> {
    private final GenericItemHandler wrapped;

    public AutomationFilterItemHander(GenericItemHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.wrapped.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.wrapped.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.canAutomationInsert(slot)) {
            return stack;
        }
        return this.wrapped.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canAutomationExtract(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.wrapped.isItemValid(slot, stack);
    }

    public boolean canAutomationInsert(int slot) {
        return this.wrapped.getContainerFactory().isInputSlot(slot);
    }

    public boolean canAutomationExtract(int slot) {
        return this.wrapped.getContainerFactory().isOutputSlot(slot);
    }

    public ListNBT serializeNBT() {
        return this.wrapped.serializeNBT();
    }

    public void deserializeNBT(ListNBT nbt) {
        this.wrapped.deserializeNBT(nbt);
    }
}

