/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.boiler.BoilerTileEntity;
import com.teammoeg.steampowered.content.engine.SteamEngineBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class SteamEngineTileEntity
extends EngineTileEntity
implements IHaveGoggleInformation {
    private FluidTank tank;
    private IFluidHandler handler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int itank) {
            return SteamEngineTileEntity.this.tank.getFluid();
        }

        public int getTankCapacity(int itank) {
            return SteamEngineTileEntity.this.tank.getCapacity();
        }

        public boolean isFluidValid(int itank, FluidStack stack) {
            return SteamEngineTileEntity.this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = SteamEngineTileEntity.this.tank.fill(resource, action);
            if (filled > 0 && action == IFluidHandler.FluidAction.EXECUTE) {
                SteamEngineTileEntity.this.func_70296_d();
                SteamEngineTileEntity.this.field_145850_b.func_184138_a(SteamEngineTileEntity.this.field_174879_c, SteamEngineTileEntity.this.func_195044_w(), SteamEngineTileEntity.this.func_195044_w(), 3);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.handler);
    private int heatup = 0;
    private int paticleInterval;

    public SteamEngineTileEntity(TileEntityType<? extends SteamEngineTileEntity> type) {
        super(type);
        this.refreshCapability();
        this.tank = new FluidTank(this.getSteamStorage(), fluidStack -> {
            ITag steamTag = FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "steam"));
            if (steamTag != null) {
                return fluidStack.getFluid().func_207185_a(steamTag);
            }
            return fluidStack.getFluid() == FluidRegistry.steam.get();
        });
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.poweredWheel == null) {
                this.attachWheel();
            }
            if (this.poweredWheel == null || this.poweredWheel.func_145837_r()) {
                if (this.appliedSpeed != 0.0f || this.appliedCapacity != 0.0f) {
                    this.appliedCapacity = 0.0f;
                    this.appliedSpeed = 0.0f;
                    this.refreshWheelSpeed();
                }
                this.heatup = 0;
                if (!this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                }
                if (((Boolean)state.func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                TileEntity te;
                Direction engineFacing = (Direction)this.func_195044_w().func_177229_b((Property)EngineBlock.field_185512_D);
                BlockPos boilerPos = this.field_174879_c.func_177967_a(engineFacing, -1);
                FluidTank tank = this.tank;
                if (this.tank.isEmpty() && (te = this.getWorld().func_175625_s(boilerPos)) instanceof BoilerTileEntity) {
                    tank = ((BoilerTileEntity)te).output;
                }
                if (this.heatup == 0 && tank.getFluidAmount() / this.getSteamConsumptionPerTick() < 40) {
                    return;
                }
                if (!tank.isEmpty() && tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).getAmount() >= this.getSteamConsumptionPerTick()) {
                    if (this.heatup >= 60) {
                        float spd = this.getGeneratingSpeed();
                        float cap = this.getGeneratingCapacity();
                        if (this.tank != tank) {
                            cap = MathHelper.func_76143_f((double)((double)cap * this.getSuckEfficiency()));
                        }
                        if (this.appliedSpeed != spd || this.appliedCapacity != cap) {
                            this.appliedSpeed = spd;
                            this.appliedCapacity = cap;
                            this.refreshWheelSpeed();
                        }
                    } else {
                        ++this.heatup;
                        this.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                        if (!((Boolean)state.func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
                        }
                    }
                } else {
                    if (this.heatup > 0) {
                        --this.heatup;
                        this.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                    }
                    if (this.appliedSpeed != 0.0f || this.appliedCapacity != 0.0f) {
                        this.appliedCapacity = 0.0f;
                        this.appliedSpeed = 0.0f;
                        this.refreshWheelSpeed();
                    }
                    if (((Boolean)state.func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
        } else if (((Boolean)this.func_195044_w().func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
            ++this.paticleInterval;
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = this.field_174879_c.func_177956_o();
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (this.paticleInterval >= 40) {
                this.paticleInterval = 0;
                this.field_145850_b.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.25f, 0.25f, false);
                Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)SteamEngineBlock.field_185512_D);
                Direction.Axis direction$axis = direction.func_176740_k();
                double d4 = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
                double d6 = this.field_145850_b.field_73012_v.nextDouble() * 9.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
                this.field_145850_b.func_195594_a((IParticleData)Particles.STEAM.get(), d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        } else {
            this.paticleInterval = 0;
        }
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (!((Boolean)this.func_195044_w().func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.not_enough_steam").func_240699_a_(TextFormatting.RED)));
        } else if (this.heatup < 60) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.heating").func_240699_a_(TextFormatting.YELLOW)));
        } else {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.running").func_240699_a_(TextFormatting.GREEN)));
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.tank.readFromNBT(compound.func_74775_l("TankContent"));
        this.heatup = compound.func_74762_e("heatup");
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("TankContent", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74768_a("heatup", this.heatup);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(capability, facing);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.handler);
        oldCap.invalidate();
    }

    public void attachWheel() {
        TileEntity te;
        Direction wheelFacing;
        Direction engineFacing = (Direction)this.func_195044_w().func_177229_b((Property)EngineBlock.field_185512_D);
        BlockPos wheelPos = this.field_174879_c.func_177967_a(engineFacing, 2);
        BlockState wheelState = this.field_145850_b.func_180495_p(wheelPos);
        if (!(this.getFlywheel() != wheelState.func_177230_c() || (wheelFacing = (Direction)wheelState.func_177229_b(FlywheelBlock.HORIZONTAL_FACING)).func_176740_k() != engineFacing.func_176746_e().func_176740_k() || FlywheelBlock.isConnected((BlockState)wheelState) && FlywheelBlock.getConnection((BlockState)wheelState) != engineFacing.func_176734_d() || (te = this.field_145850_b.func_175625_s(wheelPos)).func_145837_r() || !(te instanceof FlywheelTileEntity))) {
            if (!FlywheelBlock.isConnected((BlockState)wheelState)) {
                FlywheelBlock.setConnection((World)this.field_145850_b, (BlockPos)te.func_174877_v(), (BlockState)te.func_195044_w(), (Direction)engineFacing.func_176734_d());
            }
            this.poweredWheel = (FlywheelTileEntity)te;
            this.refreshWheelSpeed();
            return;
        }
        if (this.poweredWheel != null && !this.poweredWheel.func_145837_r()) {
            this.poweredWheel.setRotation(0.0f, 0.0f);
            this.poweredWheel = null;
        }
    }

    public abstract Block getFlywheel();

    public abstract float getGeneratingCapacity();

    public abstract float getGeneratingSpeed();

    public abstract int getSteamConsumptionPerTick();

    public abstract int getSteamStorage();

    public abstract double getSuckEfficiency();

    public void lazyTick() {
        super.lazyTick();
        this.attachWheel();
    }
}

