/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.burner;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.content.burner.BurnerBlock;
import com.teammoeg.steampowered.content.burner.IHeatReceiver;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class BurnerTileEntity
extends TileEntity
implements ITickableTileEntity,
IHaveGoggleInformation {
    private ItemStackHandler inv = new ItemStackHandler(){

        public boolean isItemValid(int slot, ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack) != 0 && stack.getContainerItem().func_190926_b();
        }
    };
    int HURemain;
    private LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inv);

    public BurnerTileEntity(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void readCustomNBT(CompoundNBT nbt) {
        this.inv.deserializeNBT(nbt.func_74775_l("inv"));
        this.HURemain = nbt.func_74762_e("hu");
    }

    public void writeCustomNBT(CompoundNBT nbt) {
        nbt.func_218657_a("inv", (INBT)this.inv.serializeNBT());
        nbt.func_74768_a("hu", this.HURemain);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readCustomNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeCustomNBT(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(cap, side);
    }

    private void refreshCapability() {
        LazyOptional<IItemHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.inv);
        oldCap.invalidate();
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            int emit = this.getHuPerTick();
            while (this.HURemain < emit && this.consumeFuel()) {
            }
            if (this.HURemain < emit) {
                if (this.HURemain > 0) {
                    this.emitHeat(this.HURemain);
                    this.HURemain = 0;
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
                if (((Boolean)state.func_177229_b((Property)BurnerBlock.LIT)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                this.HURemain -= emit;
                this.emitHeat(emit);
                this.func_70296_d();
                if (!((Boolean)state.func_177229_b((Property)BurnerBlock.LIT)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(true)));
                } else {
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
            }
        }
    }

    private boolean consumeFuel() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)BurnerBlock.REDSTONE_LOCKED)).booleanValue()) {
            return false;
        }
        int time = ForgeHooks.getBurnTime((ItemStack)this.inv.getStackInSlot(0), (IRecipeType)IRecipeType.field_222150_b);
        if (time <= 0) {
            return false;
        }
        this.inv.getStackInSlot(0).func_190918_g(1);
        this.HURemain = (int)((double)this.HURemain + (double)(time * (Integer)SPConfig.COMMON.HUPerFuelTick.get()) * this.getEfficiency());
        return true;
    }

    protected void emitHeat(float value) {
        TileEntity receiver = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        if (receiver instanceof IHeatReceiver) {
            ((IHeatReceiver)receiver).commitHeat(value);
        }
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.hu", new Object[]{this.HURemain}).func_240699_a_(TextFormatting.GOLD)));
        if (!this.inv.getStackInSlot(0).func_190926_b()) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.item", new Object[]{this.inv.getStackInSlot(0).func_190916_E(), this.inv.getStackInSlot(0).func_77973_b().func_200295_i(this.inv.getStackInSlot(0))}).func_240699_a_(TextFormatting.GRAY)));
        }
        return true;
    }

    protected abstract int getHuPerTick();

    protected abstract double getEfficiency();
}

