/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.burner.IHeatReceiver;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class BoilerTileEntity
extends TileEntity
implements IHeatReceiver,
ITickableTileEntity,
IHaveGoggleInformation {
    FluidTank input = new FluidTank(10000, s -> s.getFluid() == Fluids.field_204546_a);
    public FluidTank output = new FluidTank(10000);
    private IFluidHandler ft = new IFluidHandler(){

        public int getTanks() {
            return 2;
        }

        public FluidStack getFluidInTank(int tank) {
            switch (tank) {
                case 0: {
                    return BoilerTileEntity.this.input.getFluid();
                }
                case 1: {
                    return BoilerTileEntity.this.output.getFluid();
                }
            }
            return null;
        }

        public int getTankCapacity(int tank) {
            return 10000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && stack.getFluid() == Fluids.field_204546_a;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = BoilerTileEntity.this.input.fill(resource, action);
            if (filled > 0 && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.func_70296_d();
                BoilerTileEntity.this.field_145850_b.func_184138_a(BoilerTileEntity.this.func_174877_v(), BoilerTileEntity.this.func_195044_w(), BoilerTileEntity.this.func_195044_w(), 3);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack drained = BoilerTileEntity.this.output.drain(resource, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.func_70296_d();
                BoilerTileEntity.this.field_145850_b.func_184138_a(BoilerTileEntity.this.func_174877_v(), BoilerTileEntity.this.func_195044_w(), BoilerTileEntity.this.func_195044_w(), 3);
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = BoilerTileEntity.this.output.drain(maxDrain, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.func_70296_d();
                BoilerTileEntity.this.field_145850_b.func_184138_a(BoilerTileEntity.this.func_174877_v(), BoilerTileEntity.this.func_195044_w(), BoilerTileEntity.this.func_195044_w(), 3);
            }
            return drained;
        }
    };
    int heatreceived;
    int lastheat;
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.ft);
    private int particleInterval = 0;

    public BoilerTileEntity(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void readCustomNBT(CompoundNBT nbt) {
        this.input.readFromNBT(nbt.func_74775_l("in"));
        this.output.readFromNBT(nbt.func_74775_l("out"));
        this.heatreceived = nbt.func_74762_e("hu");
        this.lastheat = nbt.func_74762_e("lasthu");
    }

    public void writeCustomNBT(CompoundNBT nbt) {
        nbt.func_218657_a("in", (INBT)this.input.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("out", (INBT)this.output.writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("hu", this.heatreceived);
        nbt.func_74768_a("lasthu", this.lastheat);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readCustomNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeCustomNBT(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.lastheat = this.heatreceived;
            if (this.heatreceived != 0) {
                int consume = Math.min(this.getHUPerTick(), this.heatreceived);
                this.heatreceived = 0;
                double waterconsume = (Double)SPConfig.COMMON.steamPerWater.get() * 10.0;
                consume = Math.min((int)((double)this.input.drain((int)Math.ceil((double)consume / waterconsume), IFluidHandler.FluidAction.EXECUTE).getAmount() * waterconsume), consume);
                this.output.fill(new FluidStack(((FlowingFluid)FluidRegistry.steam.get()).getFluid(), consume / 10), IFluidHandler.FluidAction.EXECUTE);
                if (consume > 0) {
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                }
            }
        } else if (this.output.getFluidAmount() >= this.output.getCapacity() && this.lastheat != 0) {
            ++this.particleInterval;
            if (this.particleInterval >= 20) {
                this.particleInterval = 0;
                double d0 = this.field_174879_c.func_177958_n();
                double d1 = this.field_174879_c.func_177956_o() + 1;
                double d2 = this.field_174879_c.func_177952_p();
                this.field_145850_b.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.25f, 0.25f, false);
                for (int i = 0; i < this.field_145850_b.field_73012_v.nextInt(3) + 1; ++i) {
                    this.field_145850_b.func_195594_a((IParticleData)Particles.STEAM.get(), d0 + (double)this.field_145850_b.field_73012_v.nextFloat(), d1, d2 + (double)this.field_145850_b.field_73012_v.nextFloat(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.particleInterval = 0;
        }
    }

    @Override
    public void commitHeat(float value) {
        this.heatreceived = (int)value;
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.input));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.output));
        return true;
    }

    protected abstract int getHUPerTick();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(cap, side);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.ft);
        oldCap.invalidate();
    }
}

