/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.client.ClientUtils;
import com.teammoeg.steampowered.content.boiler.BoilerTileEntity;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;

public abstract class BoilerBlock
extends Block {
    public ActionResultType func_225533_a_(BlockState bs, World w, BlockPos bp, PlayerEntity pe, Hand h, BlockRayTraceResult br) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)pe, (Hand)h, (World)w, (BlockPos)bp, (Direction)br.func_216354_b())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public BoilerBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public int func_180641_l(BlockState b, World w, BlockPos p) {
        TileEntity te = w.func_175625_s(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            return boiler.output.getFluidAmount() * 15 / boiler.output.getCapacity();
        }
        return super.func_180641_l(b, w, p);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract int getHuConsume();

    public void func_190948_a(ItemStack i, IBlockReader w, List<ITextComponent> t, ITooltipFlag f) {
        if (Screen.func_231173_s_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.brief").func_240699_a_(TextFormatting.GOLD));
            if (ClientUtils.hasGoggles()) {
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.danger").func_240699_a_(TextFormatting.RED));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.huconsume", new Object[]{this.getHuConsume()}).func_240699_a_(TextFormatting.GOLD));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.waterconsume", new Object[]{(int)Math.ceil((double)this.getHuConsume() / 120.0)}).func_240699_a_(TextFormatting.AQUA));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.steamproduce", new Object[]{this.getHuConsume() / 10}).func_240699_a_(TextFormatting.GOLD));
            }
        } else {
            t.add((ITextComponent)TooltipHelper.holdShift((ItemDescription.Palette)ItemDescription.Palette.Gray, (boolean)false));
        }
        if (Screen.func_231172_r_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.redstone").func_240699_a_(TextFormatting.RED));
        } else {
            t.add((ITextComponent)Lang.translate((String)"tooltip.holdForControls", (Object[])new Object[]{Lang.translate((String)"tooltip.keyCtrl", (Object[])new Object[0]).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        super.func_190948_a(i, w, t, f);
    }

    public void func_176199_a(World w, BlockPos bp, Entity e) {
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof BoilerTileEntity && e instanceof LivingEntity && (((BoilerTileEntity)te).lastheat > 0 || !((BoilerTileEntity)te).output.isEmpty())) {
            e.func_70097_a(DamageSource.field_190095_e, 2.0f);
        }
    }
}

