/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.alternator;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.content.alternator.DynamoBlock;
import com.teammoeg.steampowered.content.alternator.InternalEnergyStorage;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DynamoTileEntity
extends KineticTileEntity {
    protected final InternalEnergyStorage energy = new InternalEnergyStorage(FE_CAPACITY, 0, MAX_FE_OUT);
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private boolean redstoneLocked = false;
    public static final int MAX_FE_OUT = (Integer)SPConfig.COMMON.dynamoFeMaxOut.get();
    public static final int FE_CAPACITY = (Integer)SPConfig.COMMON.dynamoFeCapacity.get();
    public static final int IMPACT = (Integer)SPConfig.COMMON.dynamoImpact.get();
    public static final double EFFICIENCY = (Double)SPConfig.COMMON.dynamoEfficiency.get();
    boolean working;

    public DynamoTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.dynamo.locked").func_240699_a_(TextFormatting.RED)));
            return true;
        }
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.energy.production").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new StringTextComponent(" " + DynamoTileEntity.format(DynamoTileEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY)));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private static String format(int n) {
        if (n > 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n > 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return n + "";
    }

    public float calculateStressApplied() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            this.lastStressApplied = 0.0f;
            return 0.0f;
        }
        this.lastStressApplied = IMPACT;
        return IMPACT;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side == this.func_195044_w().func_177229_b((Property)DynamoBlock.FACING)) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.energy.read(compound);
        this.redstoneLocked = compound.func_74767_n("redstonelocked");
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.func_74757_a("redstonelocked", this.redstoneLocked);
    }

    public void func_73660_a() {
        Direction side;
        TileEntity te;
        super.func_73660_a();
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            return;
        }
        if (((Boolean)this.func_195044_w().func_177229_b((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            if (this.working && this.hasNetwork()) {
                this.getOrCreateNetwork().updateStressFor((KineticTileEntity)this, this.calculateStressApplied());
            }
            this.working = false;
            return;
        }
        if (!this.working && this.hasNetwork()) {
            this.getOrCreateNetwork().updateStressFor((KineticTileEntity)this, this.calculateStressApplied());
        }
        this.working = true;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(DynamoTileEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        if ((te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side = (Direction)this.func_195044_w().func_177229_b((Property)DynamoBlock.FACING)))) != null) {
            te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).ifPresent(ies -> ies.receiveEnergy(this.energy.extractEnergy(ies.receiveEnergy(MAX_FE_OUT, true), false), false));
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)Math.abs(rpm) * EFFICIENCY);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyEnergy.invalidate();
    }

    public World getWorld() {
        return this.func_145831_w();
    }
}

