/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.client.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.teammoeg.steampowered.block.SPBlockPartials;
import com.teammoeg.steampowered.mixin.FlywheelTileEntityAccess;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;

public class SteelFlywheelRenderer
extends KineticTileEntityRenderer {
    public SteelFlywheelRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (!Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            BlockState blockState = te.func_195044_w();
            FlywheelTileEntity wte = (FlywheelTileEntity)te;
            FlywheelTileEntityAccess access = (FlywheelTileEntityAccess)wte;
            float speed = access.getVisualSpeed().get(partialTicks) * 3.0f / 10.0f;
            float angle = access.getAngle() + speed * partialTicks;
            IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
            if (FlywheelBlock.isConnected((BlockState)blockState)) {
                Direction connection = FlywheelBlock.getConnection((BlockState)blockState);
                light = WorldRenderer.func_228420_a_((IBlockDisplayReader)te.func_145831_w(), (BlockState)blockState, (BlockPos)te.func_174877_v().func_177972_a(connection));
                float rotation = connection.func_176740_k() == Direction.Axis.X ^ connection.func_176743_c() == Direction.AxisDirection.NEGATIVE ? -angle : angle;
                boolean flip = blockState.func_177229_b((Property)FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
                this.transformConnector(this.rotateToFacing(PartialBufferer.get((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_UPPER_ROTATING, (BlockState)blockState), connection), true, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(PartialBufferer.get((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_LOWER_ROTATING, (BlockState)blockState), connection), false, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(PartialBufferer.get((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_UPPER_SLIDING, (BlockState)blockState), connection), true, false, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(PartialBufferer.get((PartialModel)SPBlockPartials.STEEL_FLYWHEEL_LOWER_SLIDING, (BlockState)blockState), connection), false, false, rotation, flip).light(light).renderInto(ms, vb);
            }
            this.renderFlywheel(te, ms, light, blockState, angle, vb);
        }
    }

    private void renderFlywheel(KineticTileEntity te, MatrixStack ms, int light, BlockState blockState, float angle, IVertexBuilder vb) {
        BlockState referenceState = blockState.func_185907_a(Rotation.CLOCKWISE_90);
        Direction facing = (Direction)referenceState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        SuperByteBuffer wheel = PartialBufferer.getFacing((PartialModel)SPBlockPartials.STEEL_FLYWHEEL, (BlockState)referenceState, (Direction)facing);
        SteelFlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticTileEntity)te, (Direction.Axis)((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k(), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return PartialBufferer.getFacing((PartialModel)AllBlockPartials.SHAFT_HALF, (BlockState)te.func_195044_w(), (Direction)((Direction)te.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = MathHelper.func_76126_a((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        buffer.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            buffer.rotate(Direction.EAST, AngleHelper.rad((double)barAngle));
        }
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            buffer.translate(0.5625f, 0.0f, 0.0f);
        }
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        buffer.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)));
        return buffer;
    }
}

