/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class DecalBlock
extends Block {
    private static final VoxelShape NORTH = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape SOUTH = Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST = Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape WEST = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);

    public DecalBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    private boolean canSupportDecal(IWorld world, BlockPos pos, Direction side) {
        return this.canSupportDecal(world, world.func_180495_p(pos), pos, side);
    }

    private boolean canSupportDecal(IWorld world, BlockState state, BlockPos pos, Direction side) {
        return state.func_242698_a((IBlockReader)world, pos, side, BlockVoxelShape.CENTER);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockPos neighbor = ctx.func_195995_a().func_177971_a(ctx.func_195992_f().func_176730_m());
        if (!this.canSupportDecal((IWorld)ctx.func_195991_k(), neighbor, ctx.func_195992_f().func_176734_d())) {
            return null;
        }
        FluidState fluid = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)ctx.func_195992_f())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState neighbor, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!dir.equals((Object)state.func_177229_b((Property)BlockStateProperties.field_208157_J))) {
            return state;
        }
        return neighbor.func_242698_a((IBlockReader)world, neighborPos, ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d(), BlockVoxelShape.CENTER) ? super.func_196271_a(state, dir, neighbor, world, pos, neighborPos) : Blocks.field_150350_a.func_176223_P();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }
}

