/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CatwalkBlock
extends Block
implements IWrenchable,
IWaterLoggable {
    private static final VoxelShape VOXEL_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape VOXEL_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape VOXEL_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape VOXEL_EAST = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape VOXEL_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty NORTH_FENCE = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH_FENCE = BlockStateProperties.field_208153_F;
    public static final BooleanProperty EAST_FENCE = BlockStateProperties.field_208152_E;
    public static final BooleanProperty WEST_FENCE = BlockStateProperties.field_208154_G;
    public static final BooleanProperty LIFTED = BlockStateProperties.field_222513_b;

    private static boolean hasNeighborTo(Direction side, BlockItemUseContext ctx) {
        return ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177971_a(side.func_176730_m())).func_177230_c() instanceof CatwalkBlock;
    }

    public CatwalkBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIFTED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        return this.func_199600_g(state, reader, pos);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        VoxelShape shape = VOXEL_BOTTOM;
        if (((Boolean)state.func_177229_b((Property)NORTH_FENCE)).booleanValue()) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VOXEL_NORTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH_FENCE)).booleanValue()) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VOXEL_SOUTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((Boolean)state.func_177229_b((Property)EAST_FENCE)).booleanValue()) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VOXEL_EAST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((Boolean)state.func_177229_b((Property)WEST_FENCE)).booleanValue()) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VOXEL_WEST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape.func_197751_a(0.0, (Boolean)state.func_177229_b((Property)BlockStateProperties.field_222513_b) != false ? 0.0 : -0.125, 0.0);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        World world;
        Direction facing = ctx.func_195992_f();
        FluidState fluid = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        boolean lift = ctx.func_221532_j().field_72448_b - (double)ctx.func_195995_a().func_177956_o() < 0.5;
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIFTED, (Comparable)Boolean.valueOf(lift))).func_206870_a((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.NORTH && !CatwalkBlock.hasNeighborTo(Direction.NORTH, ctx)))).func_206870_a((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.SOUTH && !CatwalkBlock.hasNeighborTo(Direction.SOUTH, ctx)))).func_206870_a((Property)EAST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.EAST && !CatwalkBlock.hasNeighborTo(Direction.EAST, ctx)))).func_206870_a((Property)WEST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.WEST && !CatwalkBlock.hasNeighborTo(Direction.WEST, ctx)))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        if (!lift && CatwalkBlock.canPlaceCatwalk(world = ctx.func_195991_k(), ctx.func_195995_a().func_177982_a(0, 1, 0))) {
            world.func_180501_a(ctx.func_195995_a().func_177982_a(0, 1, 0), state, 3);
            ctx.func_195999_j().func_184586_b(ctx.func_221531_n()).func_190918_g(1);
            world.func_184133_a(ctx.func_195999_j(), ctx.func_195995_a().func_177982_a(0, 1, 0), SoundEvents.field_232777_jh_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return world.func_180495_p(ctx.func_195995_a());
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH_FENCE});
        builder.func_206894_a(new Property[]{SOUTH_FENCE});
        builder.func_206894_a(new Property[]{EAST_FENCE});
        builder.func_206894_a(new Property[]{WEST_FENCE});
        builder.func_206894_a(new Property[]{LIFTED});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public ActionResultType onWrenched(BlockState state, ItemUseContext ctx) {
        BlockState result = state;
        Vector3d relative = ctx.func_221532_j().func_178786_a((double)ctx.func_195995_a().func_177958_n(), (double)ctx.func_195995_a().func_177956_o(), (double)ctx.func_195995_a().func_177952_p());
        if (relative.field_72449_c > 0.66) {
            result = (BlockState)result.func_206870_a((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)SOUTH_FENCE) == false));
        } else if (relative.field_72449_c < 0.33) {
            result = (BlockState)result.func_206870_a((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)NORTH_FENCE) == false));
        }
        if (relative.field_72450_a > 0.66) {
            result = (BlockState)result.func_206870_a((Property)EAST_FENCE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)EAST_FENCE) == false));
        } else if (relative.field_72450_a < 0.33) {
            result = (BlockState)result.func_206870_a((Property)WEST_FENCE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)WEST_FENCE) == false));
        }
        if (result.equals(state)) {
            result = this.getRotatedBlockState(state, Direction.UP);
        }
        ctx.func_195991_k().func_180501_a(ctx.func_195995_a(), result, 3);
        return ActionResultType.SUCCESS;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.func_176740_k() == Direction.Axis.Y) {
            int state = ((Boolean)originalState.func_177229_b((Property)NORTH_FENCE) != false ? 8 : 0) + ((Boolean)originalState.func_177229_b((Property)EAST_FENCE) != false ? 4 : 0) + ((Boolean)originalState.func_177229_b((Property)SOUTH_FENCE) != false ? 2 : 0) + ((Boolean)originalState.func_177229_b((Property)WEST_FENCE) != false ? 1 : 0);
            return (BlockState)((BlockState)((BlockState)((BlockState)originalState.func_206870_a((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((state & 1) == 1))).func_206870_a((Property)EAST_FENCE, (Comparable)Boolean.valueOf((state & 8) == 8))).func_206870_a((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((state & 4) == 4))).func_206870_a((Property)WEST_FENCE, (Comparable)Boolean.valueOf((state & 2) == 2));
        }
        return originalState;
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidstate) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidstate.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidstate.func_206886_c(), fluidstate.func_206886_c().func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState neighbor, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (CatwalkBlock.isCatwalk(neighbor.func_177230_c())) {
            state = (BlockState)state.func_206870_a((Property)CatwalkBlock.getPropertyFromDirection(dir), (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public static boolean isCatwalk(ItemStack test) {
        return test.func_77973_b() instanceof BlockItem && CatwalkBlock.isCatwalk(((BlockItem)test.func_77973_b()).func_179223_d());
    }

    public static boolean isCatwalk(Block test) {
        return test instanceof CatwalkBlock;
    }

    public static boolean canPlaceCatwalk(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public static BooleanProperty getPropertyFromDirection(Direction dir) {
        switch (dir) {
            case NORTH: {
                return NORTH_FENCE;
            }
            case SOUTH: {
                return SOUTH_FENCE;
            }
            case EAST: {
                return EAST_FENCE;
            }
            case WEST: {
                return WEST_FENCE;
            }
        }
        return LIFTED;
    }
}

