/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.github.talrey.createdeco.connected.CatwalkCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalSlabCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalVertCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.items.CatwalkBlockItem;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.Registrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.ItemEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class Registration {
    private static HashMap<DyeColor, String> BRICK_COLOR_NAMES = new HashMap();
    private static ArrayList<String> COIN_TYPES = new ArrayList();
    private static HashMap<String, ItemEntry<Item>> DOOR_TYPES = new HashMap();
    public static HashMap<String, Function<String, Item>> METAL_TYPES = new HashMap();
    private static HashMap<String, Function<String, Item>> METAL_LOOKUP = new HashMap();
    public static ItemEntry<Item> WORN_BRICK_ITEM;
    public static HashMap<String, BlockEntry<Block>> WORN_BRICK_TYPES;
    public static HashMap<String, BlockEntry<StairsBlock>> WORN_STAIRS;
    public static HashMap<String, BlockEntry<SlabBlock>> WORN_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> WORN_VERTS;
    public static HashMap<String, BlockEntry<WallBlock>> WORN_WALLS;
    public static HashMap<DyeColor, BlockEntry<Block>> BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> TILE_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> LONG_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> SHORT_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_SHORT_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_SHORT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<StairsBlock>>> BRICK_STAIRS_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<SlabBlock>>> BRICK_SLAB_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<VerticalSlabBlock>>> BRICK_VERT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<WallBlock>>> BRICK_WALL_BLOCK;
    public static HashMap<String, BlockEntry<CoinStackBlock>> COIN_BLOCKS;
    public static HashMap<String, BlockEntry<DoorBlock>> DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<DoorBlock>> LOCK_DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<PaneBlock>> BAR_BLOCKS;
    public static HashMap<String, BlockEntry<PaneBlock>> BAR_PANEL_BLOCKS;
    public static HashMap<String, BlockEntry<Block>> SHEET_METAL_BLOCKS;
    public static HashMap<String, BlockEntry<StairsBlock>> SHEET_STAIRS;
    public static HashMap<String, BlockEntry<SlabBlock>> SHEET_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> SHEET_VERT_SLABS;
    public static HashMap<String, BlockEntry<FenceBlock>> MESH_FENCE_BLOCKS;
    public static HashMap<String, BlockEntry<CatwalkBlock>> CATWALK_BLOCKS;
    public static HashMap<DyeColor, BlockEntry<DecalBlock>> DECAL_BLOCKS;
    public static HashMap<DyeColor, ItemEntry<Item>> BRICK_ITEM;
    public static HashMap<String, ItemEntry<Item>> COIN_ITEM;
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACK_ITEM;
    public static ItemEntry<Item> ZINC_SHEET;
    public static ItemEntry<Item> NETHERITE_SHEET;
    public static ItemEntry<Item> NETHERITE_NUGGET;
    public static final ItemGroup BRICKS_GROUP;
    public static final ItemGroup METALS_GROUP;
    public static final ItemGroup PROPS_GROUP;
    private static final String BRICKS_NAME = "CreateDeco Bricks";
    private static final String METALS_NAME = "CreateDeco Metals";
    private static final String PROPS_NAME = "CreateDeco Props";

    public Registration() {
        BRICK_COLOR_NAMES.put(DyeColor.BLACK, "Dusk");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_GRAY, "Pearl");
        BRICK_COLOR_NAMES.put(DyeColor.RED, "Scarlet");
        BRICK_COLOR_NAMES.put(DyeColor.YELLOW, "Dean");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_BLUE, "Blue");
        BRICK_COLOR_NAMES.put(null, "Red");
        COIN_TYPES.add("Zinc");
        COIN_TYPES.add("Copper");
        COIN_TYPES.add("Brass");
        COIN_TYPES.add("Iron");
        COIN_TYPES.add("Gold");
        COIN_TYPES.add("Netherite");
        DOOR_TYPES.put("Andesite", (ItemEntry<Item>)AllItems.ANDESITE_ALLOY);
        DOOR_TYPES.put("Copper", (ItemEntry<Item>)AllItems.COPPER_INGOT);
        DOOR_TYPES.put("Zinc", (ItemEntry<Item>)AllItems.ZINC_INGOT);
        DOOR_TYPES.put("Brass", (ItemEntry<Item>)AllItems.BRASS_INGOT);
        METAL_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> (Item)AllItems.COPPER_INGOT.get());
        METAL_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> Items.field_151042_j);
        METAL_TYPES.put("Gold", str -> Items.field_151043_k);
        METAL_TYPES.put("Netherite", str -> Items.field_234759_km_);
        METAL_LOOKUP.put("Andesite", str -> str.equals("block") ? ((CasingBlock)AllBlocks.ANDESITE_CASING.get()).func_199767_j() : (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_LOOKUP.put("Zinc", str -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:zinc_block")));
        METAL_LOOKUP.put("Copper", str -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:copper_block")));
        METAL_LOOKUP.put("Brass", str -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:brass_block")));
        METAL_LOOKUP.put("Iron", str -> Items.field_221698_bk);
        METAL_LOOKUP.put("Gold", str -> Items.field_221696_bj);
        METAL_LOOKUP.put("Netherite", str -> Items.field_234794_rw_);
    }

    private static BlockEntry<?> getBrickFromName(String overlay, DyeColor dye, String shape) {
        if (overlay.trim().equals("Mossy")) {
            switch (shape.trim()) {
                case "Brick Tiles": {
                    return MOSSY_TILE_BLOCK.get(dye);
                }
                case "Long Bricks": {
                    return MOSSY_LONG_BLOCK.get(dye);
                }
                case "Short Bricks": {
                    return MOSSY_SHORT_BLOCK.get(dye);
                }
            }
            return MOSSY_BRICK_BLOCK.get(dye);
        }
        if (overlay.trim().equals("Cracked")) {
            switch (shape.trim()) {
                case "Brick Tiles": {
                    return CRACKED_TILE_BLOCK.get(dye);
                }
                case "Long Bricks": {
                    return CRACKED_LONG_BLOCK.get(dye);
                }
                case "Short Bricks": {
                    return CRACKED_SHORT_BLOCK.get(dye);
                }
            }
            return CRACKED_BRICK_BLOCK.get(dye);
        }
        switch (shape.trim()) {
            case "Brick Tiles": {
                return TILE_BRICK_BLOCK.get(dye);
            }
            case "Long Bricks": {
                return LONG_BRICK_BLOCK.get(dye);
            }
            case "Short Bricks": {
                return SHORT_BRICK_BLOCK.get(dye);
            }
        }
        return BRICK_BLOCK.get(dye);
    }

    public static String getBrickColorName(DyeColor color) {
        return BRICK_COLOR_NAMES.getOrDefault(color, "");
    }

    public static Item getBrickItemFromColor(DyeColor color) {
        return color != null ? (Item)BRICK_ITEM.get(color).get() : Items.field_151118_aC;
    }

    public static Block getBrickBlockFromColor(DyeColor color) {
        return color != null ? (Block)BRICK_BLOCK.get(color).get() : Blocks.field_196584_bK;
    }

    public static Block getBrickStairBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.field_150389_bf;
        }
        return (Block)BRICK_STAIRS_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickSlabBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.field_196571_bA;
        }
        return (Block)BRICK_SLAB_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickWallBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.field_222459_lw;
        }
        return (Block)BRICK_WALL_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickVertBlockFromColor(DyeColor color, String suf) {
        return (Block)BRICK_VERT_BLOCK.get(color).get(suf).get();
    }

    private static BlockBuilder<Block, ?> buildBrick(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase();
        String pre = prefix.replace(' ', '_').toLowerCase() + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase() + "_" + suf, Block::new);
        if (dye != null) {
            ret.initialProperties(Material.field_151576_e, dye);
        } else {
            ret.initialProperties(Material.field_151576_e);
        }
        return ret.properties(props -> props.func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185851_d)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf)))).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix).defaultLoot().simpleItem();
    }

    private static BlockBuilder<StairsBlock, ?> buildBrickStairs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase();
        String pre = prefix.replace(' ', '_').toLowerCase() + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase() + "_" + suf + "_stairs", props -> new StairsBlock(() -> ((Block)Blocks.field_150389_bf).func_176223_P(), props));
        if (dye != null) {
            ret.initialProperties(Material.field_151576_e, dye);
        } else {
            ret.initialProperties(Material.field_151576_e);
        }
        return ret.properties(props -> props.func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185851_d)).blockstate((ctx, prov) -> prov.stairsBlock((StairsBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf))).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Stairs").defaultLoot().simpleItem();
    }

    private static BlockBuilder<SlabBlock, ?> buildBrickSlabs(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase();
        String pre = prefix.replace(' ', '_').toLowerCase() + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase() + "_" + suf + "_slab", SlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.field_151576_e, dye);
        } else {
            ret.initialProperties(Material.field_151576_e);
        }
        return ret.properties(props -> props.func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185851_d)).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + pre + name.toLowerCase() + (suf.equals("") ? "" : "_" + suf)), prov.modLoc("block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf))).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Slab").defaultLoot().simpleItem();
    }

    private static BlockBuilder<VerticalSlabBlock, ?> buildBrickVerts(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase();
        String pre = prefix.replace(' ', '_').toLowerCase() + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase() + "_" + suf + "_slab_vert", VerticalSlabBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.field_151576_e, dye);
        } else {
            ret.initialProperties(Material.field_151576_e);
        }
        return ret.properties(props -> props.func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185851_d)).blockstate((ctx, prov) -> {
            String texLoc = "block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf;
            ResourceLocation tex = prov.modLoc(texLoc);
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", tex);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", tex);
            int y = 0;
            for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.field_208145_at, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.field_208145_at, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Vertical Slab").defaultLoot().simpleItem();
    }

    private static BlockBuilder<WallBlock, ?> buildBrickWalls(Registrate reg, DyeColor dye, String prefix, String name, String suffix) {
        String suf = suffix.replace(' ', '_').toLowerCase();
        String pre = prefix.replace(' ', '_').toLowerCase() + (prefix.equals("") ? "" : "_");
        BlockBuilder ret = reg.block(pre + name.toLowerCase() + "_" + suf + "_wall", WallBlock::new);
        if (dye != null) {
            ret.initialProperties(Material.field_151576_e, dye);
        } else {
            ret.initialProperties(Material.field_151576_e);
        }
        return (BlockBuilder)ret.properties(props -> props.func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185851_d)).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf))).lang(prefix + (prefix.equals("") ? "" : " ") + name + " " + suffix + " Wall").defaultLoot().tag(new ITag.INamedTag[]{BlockTags.field_219757_z}).item().model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.wallInventory("item/" + pre + name.toLowerCase() + "_" + suf + "_wall", prov.modLoc("block/palettes/bricks/" + name.toLowerCase() + "/" + pre + name.toLowerCase() + "_" + suf));
        }).build();
    }

    private static BlockBuilder<PaneBlock, ?> buildBars(Registrate reg, String metal, Function<String, Item> getter, String suffix) {
        ResourceLocation postTexture;
        File touch;
        ResourceLocation barTexture;
        String base = metal.replace(' ', '_').toLowerCase() + "_bars";
        String suf = suffix.equals("") ? "" : "_" + suffix.replace(' ', '_').toLowerCase();
        String post = "block/palettes/metal_bars/" + base + (metal == "Brass" || metal == "Netherite" ? "_post" : "");
        try {
            barTexture = new ResourceLocation("createdeco", "block/palettes/metal_bars/" + base);
            touch = new File("../src/main/resources/assets/createdeco/textures/" + barTexture.func_110623_a() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            barTexture = new ResourceLocation("block/" + base);
        }
        try {
            postTexture = new ResourceLocation("createdeco", post);
            touch = new File("../src/main/resources/assets/createdeco/textures/" + postTexture.func_110623_a() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            postTexture = barTexture;
        }
        ResourceLocation bartex = barTexture;
        ResourceLocation postex = postTexture;
        return (BlockBuilder)reg.block(base + suf, PaneBlock::new).properties(props -> props.func_226896_b_().func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_235594_P_)).blockstate((ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postex)).texture("particle", postex)).addModel()).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postex)).texture("particle", postex)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{true}).end();
            if (!suf.equals("")) {
                BlockModelBuilder sideOverlayModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf, prov.mcLoc("block/iron_bars_side"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                BlockModelBuilder sideOverlayAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf + "_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).addModel()).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).addModel()).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{true}).end();
            }
        }).tag(new ITag.INamedTag[]{BlockTags.field_219757_z}).item().model((ctx, prov) -> {
            if (suf.equals("")) {
                prov.singleTexture(base, prov.mcLoc("item/generated"), "layer0", bartex);
            } else {
                ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(base + suf, prov.mcLoc("item/generated"))).texture("layer0", bartex)).texture("layer1", prov.modLoc("block/palettes/metal_bars/" + base + suf));
            }
        }).properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).build();
    }

    public static void registerBlocks(Registrate reg) {
        reg.itemGroup(() -> BRICKS_GROUP);
        BlockBuilder wornBrick = Registration.buildBrick(reg, null, "", "Worn", "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("bb").func_200472_a("bb").func_200462_a(Character.valueOf('b'), (IItemProvider)WORN_BRICK_ITEM.get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)WORN_BRICK_ITEM.get()})).func_200464_a((Consumer)prov));
        WORN_BRICK_TYPES.put("Worn Bricks", (BlockEntry<Block>)wornBrick.register());
        String[] prefs = new String[]{"", "Cracked", "Mossy"};
        String[] sufs = new String[]{"Bricks", "Brick Tiles", "Long Bricks", "Short Bricks"};
        for (String string : prefs) {
            for (String suf : sufs) {
                String full = (string.equals("") ? "" : string + " ") + "Worn " + suf;
                if (!string.equals("") || !suf.equals("Bricks")) {
                    WORN_BRICK_TYPES.put(full, (BlockEntry<Block>)Registration.buildBrick(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((IItemProvider)((IItemProvider)WORN_BRICK_ITEM.get()), (IItemProvider[])new Item[0]), (Supplier)ctx);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((IItemProvider)((IItemProvider)WORN_BRICK_ITEM.get()), (IItemProvider[])new Item[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
                WORN_STAIRS.put(full, (BlockEntry<StairsBlock>)Registration.buildBrickStairs(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    prov.stairs(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_STAIRS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_SLABS.put(full, (BlockEntry<SlabBlock>)Registration.buildBrickSlabs(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    prov.slab(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_SLABS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_VERTS.put(full, (BlockEntry<VerticalSlabBlock>)Registration.buildBrickVerts(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("s").func_200472_a("s").func_200472_a("s").func_200462_a(Character.valueOf('s'), (IItemProvider)WORN_SLABS.get(full).get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)WORN_SLABS.get(full).get()})).func_200464_a((Consumer)prov);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_VERTS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_WALLS.put(full, (BlockEntry<WallBlock>)Registration.buildBrickWalls(reg, null, string, "Worn", suf).recipe((ctx, prov) -> {
                    prov.wall(DataIngredient.items((IItemProvider)((IItemProvider)WORN_BRICK_TYPES.get(full).get()), (IItemProvider[])new Block[0]), (Supplier)ctx);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_WALLS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
            }
        }
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye != null) {
                BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("bb").func_200472_a("bb").func_200462_a(Character.valueOf('b'), (IItemProvider)Registration.getBrickItemFromColor(dye)).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Registration.getBrickItemFromColor(dye)})).func_200464_a((Consumer)prov)).register());
            }
            TILE_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            LONG_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            SHORT_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            CRACKED_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Brick Tiles").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((IItemProvider)((IItemProvider)TILE_BRICK_BLOCK.get(dye).get()), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Long Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((IItemProvider)((IItemProvider)LONG_BRICK_BLOCK.get(dye).get()), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Cracked", name, "Short Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((IItemProvider)((IItemProvider)SHORT_BRICK_BLOCK.get(dye).get()), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx);
            }).register());
            MOSSY_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)Registration.buildBrick(reg, dye, "Mossy", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx)).register());
            HashMap<String, BlockEntry> stair = new HashMap<String, BlockEntry>();
            HashMap<String, BlockEntry> slab = new HashMap<String, BlockEntry>();
            HashMap<String, BlockEntry> vert = new HashMap<String, BlockEntry>();
            HashMap<String, BlockEntry> wall = new HashMap<String, BlockEntry>();
            for (String pre : prefs) {
                for (String suf : sufs) {
                    String full = (pre.equals("") ? "" : pre + " ") + name + " " + suf;
                    if (dye != null || !pre.equals("") || !suf.equals("Bricks")) {
                        stair.put(full, Registration.buildBrickStairs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                            prov.stairs(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((IItemProvider)Registration.getBrickStairBlockFromColor(dye, full.substring(8)), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        slab.put(full, Registration.buildBrickSlabs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                            prov.slab(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((IItemProvider)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        wall.put(full, Registration.buildBrickWalls(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.wall(DataIngredient.items((IItemProvider)((IItemProvider)Registration.getBrickFromName(pre, dye, suf).get()), (IItemProvider[])new Block[0]), (Supplier)ctx);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((IItemProvider)Registration.getBrickWallBlockFromColor(dye, full.substring(8)), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                    }
                    vert.put(full, Registration.buildBrickVerts(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((IItemProvider)Registration.getBrickBlockFromColor(dye), (IItemProvider[])new Block[0]), (Supplier)ctx, 2);
                        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("s").func_200472_a("s").func_200472_a("s").func_200462_a(Character.valueOf('s'), (IItemProvider)Registration.getBrickSlabBlockFromColor(dye, full)).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Registration.getBrickSlabBlockFromColor(dye, full)})).func_200464_a((Consumer)prov);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((IItemProvider)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (IItemProvider[])new Block[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
            }
            BRICK_STAIRS_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<StairsBlock>>)stair);
            BRICK_SLAB_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<SlabBlock>>)slab);
            BRICK_VERT_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<VerticalSlabBlock>>)vert);
            BRICK_WALL_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<WallBlock>>)wall);
        });
        reg.itemGroup(() -> PROPS_GROUP);
        COIN_TYPES.forEach(metal -> COIN_BLOCKS.put(metal.toLowerCase(), (BlockEntry<CoinStackBlock>)reg.block(metal.toLowerCase() + "_coinstack_block", CoinStackBlock::new).properties(props -> props.func_226896_b_().func_200943_b(0.5f).func_200947_a(SoundType.field_235597_S_)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int layer = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208129_ad);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + layer, prov.modLoc("block/layers_bottom_top_" + layer))).texture("side", prov.modLoc("block/" + metal.toLowerCase() + "_coinstack_side"))).texture("bottom", prov.modLoc("block/" + metal.toLowerCase() + "_coinstack_bottom"))).texture("top", prov.modLoc("block/" + metal.toLowerCase() + "_coinstack_top"))).build();
        })).lang(metal + " Stack Block").loot((table, block) -> {
            LootTable.Builder builder = LootTable.func_216119_b();
            LootPool.Builder pool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1));
            for (int layer = 1; layer <= 8; ++layer) {
                StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)COINSTACK_ITEM.get(metal).get()));
                ((StandaloneLootEntry.Builder)entry.func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlockStateProperties.field_208129_ad, layer)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)layer)));
                pool.func_216045_a((LootEntry.Builder)entry);
            }
            table.func_218507_a((Block)block, builder.func_216040_a(pool));
        }).register()));
        for (String string : DyeColor.values()) {
            DECAL_BLOCKS.put((DyeColor)string, (BlockEntry<DecalBlock>)((BlockBuilder)reg.block(string.name().toLowerCase() + "_decal", DecalBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_226896_b_().func_200943_b(0.5f).func_200947_a(SoundType.field_222475_v)).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int y = 0;
                switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/decal"))).texture("face", prov.modLoc("block/palettes/decal/" + ctx.getName()))).texture("particle", prov.modLoc("block/palettes/decal/" + ctx.getName()))).rotationY(y).build();
            })).lang(string.name() + " Decal").item().model((ctx, prov) -> {
                ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/decal/" + ctx.getName()));
            }).build()).recipe((arg_0, arg_1) -> Registration.lambda$registerBlocks$67((DyeColor)string, arg_0, arg_1)).register());
        }
        reg.itemGroup(() -> METALS_GROUP);
        DOOR_TYPES.forEach((metal, ingot) -> DOOR_BLOCKS.put(metal.toLowerCase(), (BlockEntry<DoorBlock>)((BlockBuilder)reg.block(metal.toLowerCase() + "_door", DoorBlock::new).initialProperties(Material.field_237214_y_).properties(props -> props.func_226896_b_().func_200948_a(5.0f, 5.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/" + metal.toLowerCase() + "_door_bottom"), prov.modLoc("block/" + metal.toLowerCase() + "_door_top"))).lang(metal + " Door").recipe((ctx, prov) -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("mm").func_200472_a("mm").func_200472_a("mm").func_200462_a(Character.valueOf('m'), (IItemProvider)ingot.get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ingot.get()})).func_200464_a((Consumer)prov)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.func_216119_b();
            LootPool.Builder pool = LootPool.func_216096_a();
            pool.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.LOWER)));
            table.func_218507_a((Block)block, builder.func_216040_a(pool));
        }).item().model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()));
        }).build()).register()));
        DOOR_TYPES.forEach((metal, ingot) -> LOCK_DOOR_BLOCKS.put(metal.toLowerCase(), (BlockEntry<DoorBlock>)((BlockBuilder)reg.block("locked_" + metal.toLowerCase() + "_door", DoorBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_226896_b_().func_200948_a(5.0f, 5.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/locked_" + metal.toLowerCase() + "_door_bottom"), prov.modLoc("block/locked_" + metal.toLowerCase() + "_door_top"))).loot((table, block) -> {
            LootTable.Builder builder = LootTable.func_216119_b();
            LootPool.Builder pool = LootPool.func_216096_a();
            pool.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.LOWER)));
            table.func_218507_a((Block)block, builder.func_216040_a(pool));
        }).lang("Locked " + metal + " Door").recipe((ctx, prov) -> ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200491_b((IItemProvider)Items.field_221764_cr, 1).func_200491_b((IItemProvider)DOOR_BLOCKS.get(metal.toLowerCase()).get(), 1).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{DOOR_BLOCKS.get(metal.toLowerCase()).asStack().func_77973_b()})).func_200482_a((Consumer)prov)).item().model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()));
        }).build()).register()));
        METAL_TYPES.forEach((metal, getter) -> {
            BAR_BLOCKS.put((String)metal, (BlockEntry<PaneBlock>)Registration.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "").tag(new ITag.INamedTag[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).recipe((ctx, prov) -> {
                if (!metal.equals("Iron")) {
                    ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)16).func_200472_a("mmm").func_200472_a("mmm").func_200462_a(Character.valueOf('m'), (IItemProvider)getter.apply(metal)).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)getter.apply(metal)})).func_200464_a((Consumer)prov);
                }
                ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200487_b((IItemProvider)BAR_PANEL_BLOCKS.get(metal).get()).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)BAR_PANEL_BLOCKS.get(metal).get()})).func_200485_a((Consumer)prov, new ResourceLocation("createdeco", metal.toLowerCase() + "_bars_from_panel"));
            }).register());
            BAR_PANEL_BLOCKS.put((String)metal, (BlockEntry<PaneBlock>)Registration.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "overlay").lang((metal.equals("Iron") ? "Polished Iron" : metal) + " Panel Bars ").recipe((ctx, prov) -> ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200487_b((IItemProvider)BAR_BLOCKS.get(metal).get()).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)BAR_BLOCKS.get(metal).get()})).func_200482_a((Consumer)prov)).register());
            if (metal.equals("Iron")) {
                BAR_PANEL_BLOCKS.put("Vanilla Iron", (BlockEntry<PaneBlock>)Registration.buildBars(reg, metal, getter, "overlay").lang(metal + " Panel Bars").recipe((ctx, prov) -> {
                    ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200487_b((IItemProvider)Items.field_221790_de).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_221790_de})).func_200482_a((Consumer)prov);
                    ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_221790_de).func_200487_b((IItemProvider)ctx.get()).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ctx.get()})).func_200485_a((Consumer)prov, new ResourceLocation("createdeco", "vanilla_metal_bars_from_panel"));
                }).register());
            }
            SHEET_METAL_BLOCKS.put((String)metal, (BlockEntry<Block>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase() + "_sheet_metal", Block::new).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/sheet_metal/" + ctx.getName())))).lang(metal + " Sheet Metal").defaultLoot().item().properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).build()).recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((IItemProvider)((IItemProvider)METAL_LOOKUP.get(metal).apply("block")), (IItemProvider[])new Item[0]), (Supplier)ctx, 4)).onRegister(CreateRegistrate.connectedTextures((ConnectedTextureBehaviour)new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal))))).register());
            SHEET_STAIRS.put((String)metal, (BlockEntry<StairsBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase() + "_sheet_stairs", props -> new StairsBlock(() -> ((Block)Blocks.field_150389_bf).func_176223_P(), props)).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).item().properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).build()).tag(new ITag.INamedTag[]{BlockTags.field_203291_w}).blockstate((ctx, prov) -> prov.stairsBlock((StairsBlock)ctx.get(), prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase() + "_sheet_metal"))).lang(metal + " Sheet Stairs").recipe((ctx, prov) -> {
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                prov.stairs(DataIngredient.items((IItemProvider)((IItemProvider)SHEET_METAL_BLOCKS.get(metal).get()), (IItemProvider[])new Block[0]), (Supplier)ctx, null, false);
            }).onRegister(CreateRegistrate.connectedTextures((ConnectedTextureBehaviour)new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal))))).register());
            SHEET_SLABS.put((String)metal, (BlockEntry<SlabBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase() + "_sheet_slab", SlabBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).item().properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).build()).tag(new ITag.INamedTag[]{BlockTags.field_203292_x}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + metal.toLowerCase() + "_sheet_metal"), prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase() + "_sheet_metal"))).lang(metal + " Sheet Slab").recipe((ctx, prov) -> {
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                prov.slab(DataIngredient.items((IItemProvider)((IItemProvider)SHEET_METAL_BLOCKS.get(metal).get()), (IItemProvider[])new Block[0]), (Supplier)ctx, null, false);
            }).onRegister(CreateRegistrate.connectedTextures((ConnectedTextureBehaviour)new SheetMetalSlabCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal))))).register());
            SHEET_VERT_SLABS.put((String)metal, (BlockEntry<VerticalSlabBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase() + "_sheet_slab_vert", VerticalSlabBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235594_P_)).item().properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).build()).blockstate((ctx, prov) -> {
                String texLoc = "block/palettes/sheet_metal/" + metal.toLowerCase() + "_sheet_metal";
                ResourceLocation tex = prov.modLoc(texLoc);
                BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", tex);
                BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", tex);
                int y = 0;
                for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
                    switch (dir) {
                        case NORTH: {
                            y = 0;
                            break;
                        }
                        case SOUTH: {
                            y = 180;
                            break;
                        }
                        case WEST: {
                            y = -90;
                            break;
                        }
                        case EAST: {
                            y = 90;
                        }
                    }
                    ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.field_208145_at, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{dir}).end();
                    ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.field_208145_at, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
                }
            }).loot((table, block) -> {
                LootTable.Builder builder = LootTable.func_216119_b();
                LootPool.Builder pool = LootPool.func_216096_a();
                pool.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)BlockStateProperties.field_208145_at, (Comparable)SlabType.DOUBLE)))));
                pool.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))));
                table.func_218507_a((Block)block, builder.func_216040_a(pool));
            }).recipe((ctx, prov) -> {
                ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)3).func_200472_a("s").func_200472_a("s").func_200472_a("s").func_200462_a(Character.valueOf('s'), (IItemProvider)SHEET_SLABS.get(metal).get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SHEET_METAL_BLOCKS.get(metal).asStack().func_77973_b()})).func_200464_a((Consumer)prov);
                prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)SHEET_METAL_BLOCKS.get(metal)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
            }).onRegister(CreateRegistrate.connectedTextures((ConnectedTextureBehaviour)new SheetMetalVertCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(metal))))).register());
            MESH_FENCE_BLOCKS.put((String)metal, (BlockEntry<FenceBlock>)((BlockBuilder)reg.block(metal.toLowerCase() + "_mesh_fence", FenceBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_235597_S_)).tag(new ITag.INamedTag[]{BlockTags.field_219748_G}).item().properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).model((ctx, prov) -> {
                ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase() + "_chain_link"));
            }).build()).recipe((ctx, prov) -> {
                if (metal.equals("Andesite")) {
                    ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)3).func_200472_a("psp").func_200472_a("psp").func_200462_a(Character.valueOf('p'), (IItemProvider)AllItems.ANDESITE_ALLOY.get()).func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151007_F).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllItems.ANDESITE_ALLOY.get()})).func_200464_a((Consumer)prov);
                } else {
                    ITag.INamedTag sheet = ItemTags.func_199901_a((String)("forge:plates/" + metal.toLowerCase()));
                    ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)3).func_200472_a("psp").func_200472_a("psp").func_200469_a(Character.valueOf('p'), (ITag)sheet).func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151007_F).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)sheet).func_200310_b()})).func_200464_a((Consumer)prov);
                }
            }).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                String dir = "chainlink_fence";
                boolean north = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D);
                boolean south = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F);
                boolean east = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E);
                boolean west = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G);
                int sides = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
                ResourceLocation mesh = prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase() + "_chain_link");
                ResourceLocation wall = prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase() + "_sheet_metal");
                switch (sides) {
                    case 4: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_four_way", prov.modLoc(dir + "_four_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
                    }
                    case 3: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tri_way", prov.modLoc(dir + "_tri_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (south ? (east ? 90 : -90) : 0) : 180).build();
                    }
                    case 2: {
                        if (north && south || east && west) {
                            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_straight", prov.modLoc(dir + "_straight"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(east ? 0 : 90).build();
                        }
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_corner", prov.modLoc(dir + "_corner"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (east ? 0 : -90) : (east ? 90 : 180)).build();
                    }
                    case 1: {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_end", prov.modLoc(dir + "_end"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? -90 : (south ? 90 : (east ? 0 : 180))).build();
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_post", prov.modLoc(dir + "_post"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
            })).register());
            CATWALK_BLOCKS.put((String)metal, (BlockEntry<CatwalkBlock>)((BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase() + "_catwalk", CatwalkBlock::new).initialProperties(Material.field_151573_f).properties(props -> props.func_200948_a(5.0f, 3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_().func_226896_b_().func_200947_a(SoundType.field_235594_P_)).item(CatwalkBlockItem::new).properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).model((ctx, prov) -> {
                ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/template_trapdoor_bottom"))).texture("texture", prov.modLoc("block/palettes/catwalks/" + metal.toLowerCase() + "_catwalk"));
            }).build()).recipe((ctx, prov) -> {
                if (metal.equals("Andesite")) {
                    ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)3).func_200472_a(" p ").func_200472_a("pBp").func_200472_a(" p ").func_200462_a(Character.valueOf('p'), (IItemProvider)AllItems.ANDESITE_ALLOY.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)BAR_BLOCKS.get(metal).get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllItems.ANDESITE_ALLOY.get()})).func_200464_a((Consumer)prov);
                } else {
                    ITag.INamedTag sheet = ItemTags.func_199901_a((String)("forge:plates/" + metal.toLowerCase()));
                    ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)3).func_200472_a(" p ").func_200472_a("pBp").func_200472_a(" p ").func_200469_a(Character.valueOf('p'), (ITag)sheet).func_200462_a(Character.valueOf('B'), (IItemProvider)BAR_BLOCKS.get(metal).get()).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)sheet).func_200310_b()})).func_200464_a((Consumer)prov);
                }
            }).blockstate((ctx, prov) -> {
                String texture = "createdeco:block/palettes/catwalks/" + metal.toLowerCase() + "_catwalk";
                BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_bottom", prov.modLoc("block/catwalk_bottom"))).texture("2", texture)).texture("particle", texture);
                BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_top", prov.modLoc("block/catwalk_top"))).texture("2", texture)).texture("particle", texture);
                BlockModelBuilder rail_upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_upper", prov.modLoc("block/catwalk_rail_upper"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
                BlockModelBuilder rail_lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_lower", prov.modLoc("block/catwalk_rail_lower"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)lower).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)upper).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{false}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(-90).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(180).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(0).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(-90).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(180).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(0).addModel()).condition((Property)BlockStateProperties.field_222513_b, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{true}).end();
            }).onRegister(CreateRegistrate.connectedTextures((ConnectedTextureBehaviour)new CatwalkCTBehaviour(SpriteShifts.CATWALK_TOPS.get(metal))))).register());
        });
    }

    public static void registerItems(Registrate reg) {
        reg.itemGroup(() -> BRICKS_GROUP, BRICKS_NAME);
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye == null) {
                WORN_BRICK_ITEM = reg.item("worn_brick", Item::new).recipe((ctx, prov) -> prov.blasting(DataIngredient.items((IItemProvider)Items.field_151118_aC, (IItemProvider[])new Item[0]), (Supplier)ctx, 0.3f)).register();
            } else {
                BRICK_ITEM.put((DyeColor)dye, (ItemEntry<Item>)reg.item(name.toLowerCase() + "_brick", Item::new).lang(name + " Brick").recipe((ctx, prov) -> ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ctx.get()), (int)8).func_200472_a("bbb").func_200472_a("bCb").func_200472_a("bbb").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151118_aC).func_200462_a(Character.valueOf('C'), (IItemProvider)DyeItem.func_195961_a((DyeColor)dye)).func_200465_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{DyeItem.func_195961_a((DyeColor)dye)})).func_200464_a((Consumer)prov)).register());
            }
        });
        reg.itemGroup(() -> METALS_GROUP, METALS_NAME);
        ZINC_SHEET = reg.item("zinc_sheet", Item::new).tag(new ITag.INamedTag[]{ItemTags.func_199901_a((String)"forge:plates/zinc")}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = reg.item("netherite_sheet", Item::new).properties(p -> p.func_234689_a_()).tag(new ITag.INamedTag[]{ItemTags.func_199901_a((String)"forge:plates/netherite")}).lang("Netherite Sheet").register();
        NETHERITE_NUGGET = reg.item("netherite_nugget", Item::new).properties(p -> p.func_234689_a_()).tag(new ITag.INamedTag[]{ItemTags.func_199901_a((String)"forge:nuggets/netherite")}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> Items.field_234759_km_)).register();
        reg.itemGroup(() -> PROPS_GROUP, PROPS_NAME);
        for (String metal : COIN_TYPES) {
            COIN_ITEM.put(metal, (ItemEntry<Item>)reg.item(metal.toLowerCase() + "_coin", Item::new).properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)ctx.get()), (int)4).func_200487_b((IItemProvider)COINSTACK_ITEM.get(metal).get()).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)COINSTACK_ITEM.get(metal).get()})).func_200482_a((Consumer)prov)).lang(metal + " Coin").register());
            COINSTACK_ITEM.put(metal, (ItemEntry<CoinStackItem>)reg.item(metal.toLowerCase() + "_coinstack", CoinStackItem::new).properties(p -> metal.equals("Netherite") ? p.func_234689_a_() : p).recipe((ctx, prov) -> ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200491_b((IItemProvider)COIN_ITEM.get(metal).get(), 4).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)COIN_ITEM.get(metal).get()})).func_200482_a((Consumer)prov)).lang(metal + " Coinstack").register());
        }
    }

    private static /* synthetic */ void lambda$registerBlocks$67(DyeColor color, DataGenContext ctx, RegistrateRecipeProvider prov) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ctx.get())).func_200491_b((IItemProvider)AllItems.IRON_SHEET.get(), 1).func_200491_b((IItemProvider)DyeItem.func_195961_a((DyeColor)color), 1).func_200483_a("has_item", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllItems.IRON_SHEET.get()})).func_200483_a("has_dye", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{DyeItem.func_195961_a((DyeColor)color)})).func_200482_a((Consumer)prov);
    }

    static {
        WORN_BRICK_TYPES = new HashMap();
        WORN_STAIRS = new HashMap();
        WORN_SLABS = new HashMap();
        WORN_VERTS = new HashMap();
        WORN_WALLS = new HashMap();
        BRICK_BLOCK = new HashMap();
        TILE_BRICK_BLOCK = new HashMap();
        LONG_BRICK_BLOCK = new HashMap();
        SHORT_BRICK_BLOCK = new HashMap();
        CRACKED_BRICK_BLOCK = new HashMap();
        CRACKED_TILE_BLOCK = new HashMap();
        CRACKED_LONG_BLOCK = new HashMap();
        CRACKED_SHORT_BLOCK = new HashMap();
        MOSSY_BRICK_BLOCK = new HashMap();
        MOSSY_TILE_BLOCK = new HashMap();
        MOSSY_LONG_BLOCK = new HashMap();
        MOSSY_SHORT_BLOCK = new HashMap();
        BRICK_STAIRS_BLOCK = new HashMap();
        BRICK_SLAB_BLOCK = new HashMap();
        BRICK_VERT_BLOCK = new HashMap();
        BRICK_WALL_BLOCK = new HashMap();
        COIN_BLOCKS = new HashMap();
        DOOR_BLOCKS = new HashMap();
        LOCK_DOOR_BLOCKS = new HashMap();
        BAR_BLOCKS = new HashMap();
        BAR_PANEL_BLOCKS = new HashMap();
        SHEET_METAL_BLOCKS = new HashMap();
        SHEET_STAIRS = new HashMap();
        SHEET_SLABS = new HashMap();
        SHEET_VERT_SLABS = new HashMap();
        MESH_FENCE_BLOCKS = new HashMap();
        CATWALK_BLOCKS = new HashMap();
        DECAL_BLOCKS = new HashMap();
        BRICK_ITEM = new HashMap();
        COIN_ITEM = new HashMap();
        COINSTACK_ITEM = new HashMap();
        BRICKS_GROUP = new DecoItemGroup("createdeco.bricks", () -> BRICK_BLOCK.get(DyeColor.LIGHT_BLUE).asStack());
        METALS_GROUP = new DecoItemGroup("createdeco.metals", () -> BAR_BLOCKS.get("Brass").asStack());
        PROPS_GROUP = new DecoItemGroup("createdeco.props", () -> COINSTACK_ITEM.get("Brass").asStack());
    }

    public static class DecoItemGroup
    extends ItemGroup {
        private final Supplier<ItemStack> sup;

        public DecoItemGroup(String name, Supplier<ItemStack> supplier) {
            super(name);
            this.sup = supplier;
        }

        public ItemStack func_78016_d() {
            return this.sup.get();
        }
    }
}

