/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.ForgeHooksClient;

public class BlockEntityCustomItemRenderer<T extends TileEntity>
implements CustomItemRenderer {
    protected final boolean renderItemModel;
    protected final Supplier<T> initEntity;
    protected final BiConsumer<ItemStack, T> entityUpdater;
    protected T blockEntity;

    public BlockEntityCustomItemRenderer(boolean renderItemModel, Supplier<T> initEntity, BiConsumer<ItemStack, T> entityUpdater) {
        this.renderItemModel = renderItemModel;
        this.initEntity = initEntity;
        this.entityUpdater = entityUpdater;
    }

    @Override
    public void render(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int combinedLight, int combinedOverlay) {
        if (this.blockEntity == null) {
            this.blockEntity = (TileEntity)this.initEntity.get();
            if (this.blockEntity == null) {
                throw new RuntimeException("Init entity function must not return a null block entity!");
            }
        }
        this.entityUpdater.accept(itemStack, (ItemStack)this.blockEntity);
        if (this.renderItemModel) {
            this.renderDefaultModel(itemStack, transformType, poseStack, bufferSource, combinedLight, combinedOverlay);
        }
        TileEntityRendererDispatcher.field_147556_a.func_228852_a_(this.blockEntity, poseStack, bufferSource, combinedLight, combinedOverlay);
    }

    protected void renderDefaultModel(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int combinedLight, int combinedOverlay) {
        Block block;
        if (itemStack.func_190926_b()) {
            return;
        }
        ItemRenderer itemRenderer = ClientUtils.getItemRenderer();
        IBakedModel model = itemRenderer.func_184393_a(itemStack, null, null);
        boolean fabulous = transformType != ItemCameraTransforms.TransformType.GUI && !transformType.func_241716_a_() && itemStack.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStack.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        if (model.isLayered()) {
            ForgeHooksClient.drawItemLayered((ItemRenderer)itemRenderer, (IBakedModel)model, (ItemStack)itemStack, (MatrixStack)poseStack, (IRenderTypeBuffer)bufferSource, (int)combinedLight, (int)combinedOverlay, (boolean)fabulous);
        } else {
            RenderType renderType = RenderTypeLookup.func_239219_a_((ItemStack)itemStack, (boolean)fabulous);
            IVertexBuilder vertexConsumer = fabulous ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.func_77962_s()) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.func_77962_s());
            itemRenderer.func_229114_a_(model, itemStack, combinedLight, combinedOverlay, poseStack, vertexConsumer);
        }
    }
}

