/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public final class CreativeItemGroup
extends ItemGroup {
    private final String identifier;
    private final ITextComponent displayName;
    private final Supplier<ItemStack> icon;
    private Consumer<Consumer<ItemStack>> filler;
    private Comparator<ItemStack> sorter;

    public static CreativeItemGroup create(String modid, String name, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String identifier = modid + "." + name;
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(identifier, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, IItemProvider icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.func_199767_j().func_190903_i());
    }

    public static CreativeItemGroup create(String modid, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, IItemProvider icon) {
        return CreativeItemGroup.create(modid, () -> icon.func_199767_j().func_190903_i());
    }

    public static ItemGroup getBuildingBlocks() {
        return ItemGroup.field_78030_b;
    }

    public static ItemGroup getDecoration() {
        return ItemGroup.field_78031_c;
    }

    public static ItemGroup getRedstone() {
        return ItemGroup.field_78028_d;
    }

    public static ItemGroup getTransportation() {
        return ItemGroup.field_78029_e;
    }

    public static ItemGroup getMisc() {
        return ItemGroup.field_78026_f;
    }

    public static ItemGroup getSearch() {
        return ItemGroup.field_78027_g;
    }

    public static ItemGroup getFood() {
        return ItemGroup.field_78039_h;
    }

    public static ItemGroup getTools() {
        return ItemGroup.field_78040_i;
    }

    public static ItemGroup getCombat() {
        return ItemGroup.field_78037_j;
    }

    public static ItemGroup getBrewing() {
        return ItemGroup.field_78038_k;
    }

    private CreativeItemGroup(String identifier, String translationKey, Supplier<ItemStack> icon) {
        super(identifier);
        this.identifier = identifier;
        this.displayName = TextComponents.translation(translationKey).get();
        this.icon = icon;
    }

    public CreativeItemGroup filler(Consumer<Consumer<ItemStack>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<ItemStack> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public ItemStack func_78016_d() {
        ItemStack stack = this.icon.get();
        if (stack == null || stack.func_190926_b()) {
            throw new RuntimeException("Item group '" + this.identifier + "'s icon stack must not be empty!");
        }
        return stack;
    }

    public ITextComponent func_242392_c() {
        return this.displayName;
    }

    public String func_200300_c() {
        return this.identifier;
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        if (this.filler == null) {
            super.func_78018_a(items);
        } else {
            this.filler.accept(arg_0 -> items.add(arg_0));
        }
        if (this.sorter != null) {
            items.sort(this.sorter);
        }
    }
}

