/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;

public class WidgetScreen<T extends Widget>
extends Screen {
    protected final T widget;
    private boolean initialized = false;
    private boolean isPauseScreen = false;

    public static <T extends Widget> WidgetScreen<T> of(T widget) {
        return new WidgetScreen<T>(widget);
    }

    public static <T extends Widget> WidgetScreen<T> of(T widget, boolean isPauseScreen) {
        return new WidgetScreen<T>(widget, isPauseScreen);
    }

    public WidgetScreen(T widget, boolean isPauseScreen) {
        super((ITextComponent)TextComponents.empty().get());
        this.widget = widget;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetScreen(T widget) {
        this(widget, false);
    }

    protected void func_231160_c_() {
        if (!this.initialized) {
            this.widget.initialize();
            this.initialized = true;
        }
    }

    public void func_231175_as__() {
        this.widget.discard();
        super.func_231175_as__();
    }

    public void func_231023_e_() {
        this.widget.update();
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(poseStack);
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        int offsetY = (this.field_230709_l_ - this.widget.height()) / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)offsetX, (float)offsetY, (float)0.0f);
        this.widget.setFocused((mouseX -= offsetX) >= 0 && mouseX < this.widget.width() && (mouseY -= offsetY) >= 0 && mouseY < this.widget.height());
        this.widget.renderBackground(poseStack, mouseX, mouseY);
        this.widget.render(poseStack, mouseX, mouseY);
        this.widget.renderForeground(poseStack, mouseX, mouseY);
        this.widget.renderOverlay(poseStack, mouseX, mouseY);
        this.widget.renderTooltips(poseStack, mouseX, mouseY);
        RenderSystem.popMatrix();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mousePressed((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.field_230709_l_ - this.widget.height()) / 2)), button, false) || super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.field_230709_l_ - this.widget.height()) / 2)), button, false) || super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.field_230709_l_ - this.widget.height()) / 2)), amount, false) || super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputMappings.Input key = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(key)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.func_231042_a_(character, modifiers);
    }

    public boolean func_231177_au__() {
        return this.isPauseScreen;
    }

    public String func_231167_h_() {
        ITextComponent message = this.widget.getNarrationMessage();
        return message == null ? "" : TextComponents.fromTextComponent(message).format();
    }
}

