/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.AdvancementGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class RecipeGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, RecipeBuilder<?>> recipes = new HashMap();
    private final Advancements advancements;

    public RecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.advancements = new Advancements(modid, cache);
    }

    @Override
    public void save() {
        this.advancements.generate();
        for (RecipeBuilder<?> recipeBuilder : this.recipes.values()) {
            JsonObject json = new JsonObject();
            HashMap<String, JsonObject> subRecipes = new HashMap<String, JsonObject>();
            subRecipes.put("", json);
            json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(((RecipeBuilder)recipeBuilder).serializer).toString());
            if (recipeBuilder instanceof ShapedRecipeBuilder) {
                Object character2;
                HashSet<Character> characters = new HashSet<Character>();
                for (String row : ((ShapedRecipeBuilder)recipeBuilder).pattern) {
                    for (char c : row.toCharArray()) {
                        if (c == ' ' || !characters.add(Character.valueOf(c)) || ((ShapedRecipeBuilder)recipeBuilder).inputs.containsKey(Character.valueOf(c))) continue;
                        throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' is missing an input for character '" + c + "'!");
                    }
                }
                for (Object character2 : ((ShapedRecipeBuilder)recipeBuilder).inputs.keySet()) {
                    if (characters.contains(character2)) continue;
                    throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' has unused input with key '" + character2 + "'!");
                }
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                json.add("pattern", (JsonElement)RecipeGenerator.createArray(((ShapedRecipeBuilder)recipeBuilder).pattern));
                JsonObject keysJson = new JsonObject();
                character2 = ((ShapedRecipeBuilder)recipeBuilder).inputs.entrySet().iterator();
                while (character2.hasNext()) {
                    Map.Entry input = (Map.Entry)character2.next();
                    keysJson.add(((Character)input.getKey()).toString(), ((Ingredient)input.getValue()).func_200304_c());
                }
                json.add("key", (JsonElement)keysJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
                if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                    resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
                }
                if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                    resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof ShapelessRecipeBuilder) {
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                JsonArray ingredientsJson = new JsonArray();
                for (Ingredient input : ((ShapelessRecipeBuilder)recipeBuilder).inputs) {
                    ingredientsJson.add(input.func_200304_c());
                }
                json.add("ingredients", (JsonElement)ingredientsJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
                if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                    resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
                }
                if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                    resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof SmeltingRecipeBuilder) {
                JsonObject recipeJson;
                if (((SmeltingRecipeBuilder)recipeBuilder).includeBlasting) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:blasting");
                    RecipeGenerator.serializeCookingRecipe(recipeJson, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_blasting", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmoking) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:smoking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_smoking", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeCampfire) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:campfire_cooking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_campfire", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmelting) {
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 1, 200);
                } else {
                    subRecipes.remove("");
                }
            } else if (recipeBuilder instanceof SmithingRecipeBuilder) {
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                json.add("base", ((SmithingRecipeBuilder)recipeBuilder).base.func_200304_c());
                json.add("addition", ((SmithingRecipeBuilder)recipeBuilder).addition.func_200304_c());
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
                if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                    resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
                }
                if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                    resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof StoneCuttingRecipeBuilder) {
                json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
                json.add("ingredient", ((StoneCuttingRecipeBuilder)recipeBuilder).input.func_200304_c());
                json.addProperty("result", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
                json.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
            }
            for (Map.Entry subRecipe : subRecipes.entrySet()) {
                json = (JsonObject)subRecipe.getValue();
                if (!((RecipeBuilder)recipeBuilder).conditions.isEmpty()) {
                    json = ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(json, ((RecipeBuilder)recipeBuilder).conditions);
                }
                ResourceLocation identifier = recipeBuilder.identifier;
                this.cache.saveJsonResource(ResourceType.DATA, json, identifier.func_110624_b(), "recipes", identifier.func_110623_a() + (String)subRecipe.getKey());
            }
        }
        this.advancements.save();
    }

    private static void serializeCookingRecipe(JsonObject json, SmeltingRecipeBuilder recipeBuilder, int durationDivider, int defaultDuration) {
        int duration;
        json.addProperty("group", ((RecipeBuilder)recipeBuilder).group);
        json.add("ingredient", recipeBuilder.input.func_200304_c());
        if (((RecipeBuilder)recipeBuilder).outputTag == null && ((RecipeBuilder)recipeBuilder).outputCount == 1) {
            json.addProperty("result", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
        } else {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Registries.ITEMS.getIdentifier(((RecipeBuilder)recipeBuilder).output.func_199767_j()).toString());
            if (((RecipeBuilder)recipeBuilder).outputCount != 1) {
                resultJson.addProperty("count", (Number)((RecipeBuilder)recipeBuilder).outputCount);
            }
            if (((RecipeBuilder)recipeBuilder).outputTag != null) {
                resultJson.addProperty("nbt", ((RecipeBuilder)recipeBuilder).outputTag.toString());
            }
            json.add("result", (JsonElement)resultJson);
        }
        if (recipeBuilder.experience != 0) {
            json.addProperty("experience", (Number)recipeBuilder.experience);
        }
        if ((duration = recipeBuilder.duration / durationDivider) != defaultDuration) {
            json.addProperty("cookingtime", (Number)duration);
        }
    }

    private static JsonArray createArray(Iterable<String> elements) {
        JsonArray array = new JsonArray();
        for (String element : elements) {
            array.add(element);
        }
        return array;
    }

    protected <T extends RecipeBuilder<T>> T recipe(ResourceLocation recipeLocation, T builder) {
        if (this.recipes.containsKey(recipeLocation)) {
            throw new RuntimeException("Duplicate recipe '" + recipeLocation + "' of types '" + this.recipes.get(recipeLocation).getClass().getName() + "' and '" + builder.getClass().getName() + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, builder.identifier.func_110624_b(), "recipes", builder.identifier.func_110623_a(), ".json");
        this.recipes.put(recipeLocation, builder);
        return builder;
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.recipe(recipeLocation, new ShapedRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.shaped(this.modid, identifier, output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(IItemProvider output, CompoundNBT nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.func_199767_j());
        return this.recipe(identifier, new ShapedRecipeBuilder(identifier, output, nbt, amount));
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, IItemProvider output, int amount) {
        return this.shaped(recipeLocation, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, IItemProvider output, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, IItemProvider output, int amount) {
        return this.shaped(this.modid, identifier, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(IItemProvider output, int amount) {
        return this.shaped(output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, IItemProvider output) {
        return this.shaped(recipeLocation, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, IItemProvider output) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String identifier, IItemProvider output) {
        return this.shaped(this.modid, identifier, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(IItemProvider output) {
        return this.shaped(output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemStack output) {
        return this.shaped(recipeLocation, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemStack output) {
        return this.shaped(new ResourceLocation(namespace, identifier), (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemStack output) {
        return this.shaped(this.modid, identifier, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapedRecipeBuilder shaped(ItemStack output) {
        return this.shaped((IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.recipe(recipeLocation, new ShapelessRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.shapeless(this.modid, identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(IItemProvider output, CompoundNBT nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.func_199767_j());
        return this.shapeless(identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, IItemProvider output, int amount) {
        return this.shapeless(recipeLocation, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, IItemProvider output, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, IItemProvider output, int amount) {
        return this.shapeless(this.modid, identifier, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(IItemProvider output, int amount) {
        return this.shapeless(output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, IItemProvider output) {
        return this.shapeless(recipeLocation, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, IItemProvider output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, IItemProvider output) {
        return this.shapeless(this.modid, identifier, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(IItemProvider output) {
        return this.shapeless(output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemStack output) {
        return this.shapeless(recipeLocation, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemStack output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemStack output) {
        return this.shapeless(this.modid, identifier, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected ShapelessRecipeBuilder shapeless(ItemStack output) {
        return this.shapeless((IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.recipe(recipeLocation, new SmeltingRecipeBuilder(recipeLocation, output, nbt, amount)).includeSmelting();
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.smelting(this.modid, identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(IItemProvider output, CompoundNBT nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.func_199767_j());
        return this.smelting(identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, IItemProvider output, int amount) {
        return this.smelting(recipeLocation, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, IItemProvider output, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, IItemProvider output, int amount) {
        return this.smelting(this.modid, identifier, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(IItemProvider output, int amount) {
        return this.smelting(output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, IItemProvider output) {
        return this.smelting(recipeLocation, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, IItemProvider output) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, IItemProvider output) {
        return this.smelting(this.modid, identifier, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(IItemProvider output) {
        return this.smelting(output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemStack output) {
        return this.smelting(recipeLocation, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemStack output) {
        return this.smelting(new ResourceLocation(namespace, identifier), (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemStack output) {
        return this.smelting(this.modid, identifier, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmeltingRecipeBuilder smelting(ItemStack output) {
        return this.smelting((IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.recipe(recipeLocation, new SmithingRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, IItemProvider output, CompoundNBT nbt, int amount) {
        return this.smithing(this.modid, identifier, output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(IItemProvider output, CompoundNBT nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.func_199767_j());
        return this.smithing(identifier, output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, IItemProvider output, int amount) {
        return this.smithing(recipeLocation, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, IItemProvider output, int amount) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, IItemProvider output, int amount) {
        return this.smithing(this.modid, identifier, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(IItemProvider output, int amount) {
        return this.smithing(output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, IItemProvider output) {
        return this.smithing(recipeLocation, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, IItemProvider output) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String identifier, IItemProvider output) {
        return this.smithing(this.modid, identifier, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(IItemProvider output) {
        return this.smithing(output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemStack output) {
        return this.smithing(recipeLocation, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemStack output) {
        return this.smithing(new ResourceLocation(namespace, identifier), (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemStack output) {
        return this.smithing(this.modid, identifier, (IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected SmithingRecipeBuilder smithing(ItemStack output) {
        return this.smithing((IItemProvider)output.func_77973_b(), output.func_77942_o() && !output.func_77978_p().isEmpty() ? output.func_77978_p() : null, output.func_190916_E());
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, IItemProvider output, int amount) {
        return this.recipe(recipeLocation, new StoneCuttingRecipeBuilder(recipeLocation, output, amount));
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, IItemProvider output, int amount) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, IItemProvider output, int amount) {
        return this.stoneCutting(this.modid, identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(IItemProvider output, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.func_199767_j());
        return this.stoneCutting(identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, IItemProvider output) {
        return this.stoneCutting(recipeLocation, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, IItemProvider output) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, IItemProvider output) {
        return this.stoneCutting(this.modid, identifier, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(IItemProvider output) {
        return this.stoneCutting(output, 1);
    }

    @Override
    public String getName() {
        return this.modName + " Recipe Generator";
    }

    private final class Advancements
    extends AdvancementGenerator {
        public Advancements(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (RecipeBuilder recipe : RecipeGenerator.this.recipes.values()) {
                if (!recipe.hasAdvancement) continue;
                ItemGroup tab = recipe.output.func_199767_j().func_77640_w();
                String namespace = recipe.identifier.func_110624_b();
                String identifier = "recipes/" + (tab == null ? "" : tab.func_200300_c() + "/") + recipe.identifier.func_110623_a();
                if (recipe instanceof SmeltingRecipeBuilder) {
                    if (((SmeltingRecipeBuilder)recipe).includeSmelting) {
                        this.createAdvancement(namespace, identifier + "_smelting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeBlasting) {
                        this.createAdvancement(namespace, identifier + "_blasting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeSmoking) {
                        this.createAdvancement(namespace, identifier + "_smoking", recipe);
                    }
                    if (!((SmeltingRecipeBuilder)recipe).includeCampfire) continue;
                    this.createAdvancement(namespace, identifier + "_campfire", recipe);
                    continue;
                }
                this.createAdvancement(namespace, identifier, recipe);
            }
        }

        private void createAdvancement(String namespace, String identifier, RecipeBuilder<?> recipe) {
            AdvancementGenerator.AdvancementBuilder builder = this.advancement(namespace, identifier).parent(new ResourceLocation("minecraft", "recipes/root")).criterion("has_the_recipe", (CriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)recipe.identifier)).icon(((RecipeBuilder)recipe).output, ((RecipeBuilder)recipe).outputTag).dontShowToast().dontAnnounceToChat().rewardRecipe(recipe.identifier);
            String[] triggers = new String[((RecipeBuilder)recipe).unlockedBy.size() + 1];
            triggers[0] = "has_the_recipe";
            if (((RecipeBuilder)recipe).unlockedBy.size() == 1) {
                builder.criterion("recipe_condition", (CriterionInstance)((RecipeBuilder)recipe).unlockedBy.get(0));
                triggers[1] = "recipe_condition";
            } else {
                for (int i = 0; i < ((RecipeBuilder)recipe).unlockedBy.size(); ++i) {
                    builder.criterion("recipe_condition" + (i + 1), (CriterionInstance)((RecipeBuilder)recipe).unlockedBy.get(i));
                    triggers[i + 1] = "recipe_condition" + (i + 1);
                }
            }
            builder.requirementGroup(triggers);
            ((RecipeBuilder)recipe).conditions.forEach(builder::condition);
        }
    }

    protected static class StoneCuttingRecipeBuilder
    extends RecipeBuilder<StoneCuttingRecipeBuilder> {
        private Ingredient input;

        private StoneCuttingRecipeBuilder(ResourceLocation identifier, IItemProvider output, int outputCount) {
            super(identifier, IRecipeSerializer.field_222175_s, output, null, outputCount);
        }

        public StoneCuttingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public StoneCuttingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public StoneCuttingRecipeBuilder input(IItemProvider ... items) {
            return this.input(Ingredient.func_199804_a((IItemProvider[])items));
        }

        public StoneCuttingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public StoneCuttingRecipeBuilder input(ITag<Item> tag) {
            return this.input(Ingredient.func_199805_a(tag));
        }
    }

    protected static class SmithingRecipeBuilder
    extends RecipeBuilder<SmithingRecipeBuilder> {
        private Ingredient base;
        private Ingredient addition;

        private SmithingRecipeBuilder(ResourceLocation identifier, IItemProvider output, CompoundNBT outputTag, int outputCount) {
            super(identifier, IRecipeSerializer.field_234826_u_, output, outputTag, outputCount);
        }

        public SmithingRecipeBuilder base(Ingredient ingredient) {
            this.base = ingredient;
            return this;
        }

        public SmithingRecipeBuilder base(Ingredient ... ingredients) {
            return this.base(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmithingRecipeBuilder base(IItemProvider ... items) {
            return this.base(Ingredient.func_199804_a((IItemProvider[])items));
        }

        public SmithingRecipeBuilder base(ItemStack ... itemStacks) {
            return this.base(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public SmithingRecipeBuilder base(ITag<Item> tag) {
            return this.base(Ingredient.func_199805_a(tag));
        }

        public SmithingRecipeBuilder addition(Ingredient ingredient) {
            this.addition = ingredient;
            return this;
        }

        public SmithingRecipeBuilder addition(Ingredient ... ingredients) {
            return this.addition(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmithingRecipeBuilder addition(IItemProvider ... items) {
            return this.addition(Ingredient.func_199804_a((IItemProvider[])items));
        }

        public SmithingRecipeBuilder addition(ItemStack ... itemStacks) {
            return this.addition(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public SmithingRecipeBuilder addition(ITag<Item> tag) {
            return this.addition(Ingredient.func_199805_a(tag));
        }
    }

    protected static class SmeltingRecipeBuilder
    extends RecipeBuilder<SmeltingRecipeBuilder> {
        private boolean includeSmelting;
        private boolean includeBlasting;
        private boolean includeCampfire;
        private boolean includeSmoking;
        private Ingredient input;
        private int experience;
        private int duration = 200;

        private SmeltingRecipeBuilder(ResourceLocation identifier, IItemProvider output, CompoundNBT outputTag, int count) {
            super(identifier, (IRecipeSerializer)IRecipeSerializer.field_222171_o, output, outputTag, count);
        }

        public SmeltingRecipeBuilder includeSmelting(boolean includeSmelting) {
            this.includeSmelting = includeSmelting;
            return this;
        }

        public SmeltingRecipeBuilder includeSmelting() {
            return this.includeSmelting(true);
        }

        public SmeltingRecipeBuilder includeBlasting(boolean includeBlasting) {
            this.includeBlasting = includeBlasting;
            return this;
        }

        public SmeltingRecipeBuilder includeBlasting() {
            return this.includeBlasting(true);
        }

        public SmeltingRecipeBuilder includeCampfire(boolean includeCampfire) {
            this.includeCampfire = includeCampfire;
            return this;
        }

        public SmeltingRecipeBuilder includeCampfire() {
            return this.includeCampfire(true);
        }

        public SmeltingRecipeBuilder includeSmoking(boolean includeSmoking) {
            this.includeSmoking = includeSmoking;
            return this;
        }

        public SmeltingRecipeBuilder includeSmoking() {
            return this.includeSmoking(true);
        }

        public SmeltingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public SmeltingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmeltingRecipeBuilder input(IItemProvider ... items) {
            return this.input(Ingredient.func_199804_a((IItemProvider[])items));
        }

        public SmeltingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public SmeltingRecipeBuilder input(ITag<Item> tag) {
            return this.input(Ingredient.func_199805_a(tag));
        }

        public SmeltingRecipeBuilder experience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Experience for recipe '" + this.identifier + "' cannot be negative!");
            }
            this.experience = experience;
            return this;
        }

        public SmeltingRecipeBuilder duration(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("Duration for recipe '" + this.identifier + "' must be greater than 0!");
            }
            this.duration = ticks;
            return this;
        }

        public SmeltingRecipeBuilder durationSeconds(int seconds) {
            return this.duration(seconds * 20);
        }
    }

    protected static class ShapelessRecipeBuilder
    extends RecipeBuilder<ShapelessRecipeBuilder> {
        private final List<Ingredient> inputs = new ArrayList<Ingredient>();

        private ShapelessRecipeBuilder(ResourceLocation identifier, IItemProvider output, CompoundNBT outputTag, int outputCount) {
            super(identifier, IRecipeSerializer.field_222158_b, output, outputTag, outputCount);
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Cannot add an ingredient '" + count + "' times to recipe '" + this.identifier + "'!");
            }
            if (this.inputs.size() + count > 9) {
                throw new RuntimeException("Recipe '" + this.identifier + "' can have at most 9 inputs!");
            }
            for (int i = 0; i < count; ++i) {
                this.inputs.add(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient) {
            return this.input(ingredient, 1);
        }

        public ShapelessRecipeBuilder input(IItemProvider item, int count) {
            return this.input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), count);
        }

        public ShapelessRecipeBuilder input(IItemProvider item) {
            return this.input(item, 1);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack, int count) {
            return this.input(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack}), count);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack) {
            return this.input(itemStack, 1);
        }

        public ShapelessRecipeBuilder input(ITag<Item> tag, int count) {
            return this.input(Ingredient.func_199805_a(tag), count);
        }

        public ShapelessRecipeBuilder input(ITag<Item> tag) {
            return this.input(Ingredient.func_199805_a(tag), 1);
        }

        public ShapelessRecipeBuilder inputs(Ingredient ... ingredients) {
            for (Ingredient ingredient : ingredients) {
                this.input(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(IItemProvider ... items) {
            for (IItemProvider item : items) {
                this.input(item);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(ItemStack ... itemStacks) {
            for (ItemStack itemStack : itemStacks) {
                this.input(itemStack);
            }
            return this;
        }
    }

    protected static class ShapedRecipeBuilder
    extends RecipeBuilder<ShapedRecipeBuilder> {
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, Ingredient> inputs = new HashMap<Character, Ingredient>();

        private ShapedRecipeBuilder(ResourceLocation identifier, IItemProvider output, CompoundNBT outputTag, int outputCount) {
            super(identifier, IRecipeSerializer.field_222157_a, output, outputTag, outputCount);
        }

        public ShapedRecipeBuilder pattern(String row) {
            if (row.isEmpty()) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' cannot be empty!");
            }
            if (row.length() > 3) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' can have at most 3 characters, not '" + row.length() + "'!");
            }
            for (String otherRow : this.pattern) {
                if (row.length() == otherRow.length()) continue;
                throw new IllegalArgumentException("Pattern rows for recipe '" + this.identifier + "' must have the same length!");
            }
            this.pattern.add(row);
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ingredient) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new RuntimeException("Duplicate key '" + key + "' for recipe '" + this.identifier + "'!");
            }
            this.inputs.put(Character.valueOf(key), ingredient);
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ... ingredients) {
            return this.input(key, Ingredient.merge(Arrays.asList(ingredients)));
        }

        public ShapedRecipeBuilder input(char key, IItemProvider ... items) {
            return this.input(key, Ingredient.func_199804_a((IItemProvider[])items));
        }

        public ShapedRecipeBuilder input(char key, ItemStack ... itemStacks) {
            return this.input(key, Ingredient.func_193369_a((ItemStack[])itemStacks));
        }

        public ShapedRecipeBuilder input(char key, ITag<Item> tag) {
            return this.input(key, Ingredient.func_199805_a(tag));
        }
    }

    public static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected final ResourceLocation identifier;
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final IItemProvider output;
        private final CompoundNBT outputTag;
        private final int outputCount;
        private IRecipeSerializer<?> serializer;
        private String group;
        private boolean hasAdvancement = true;
        private final List<CriterionInstance> unlockedBy = new ArrayList<CriterionInstance>();

        protected RecipeBuilder(ResourceLocation identifier, IRecipeSerializer serializer, IItemProvider output, CompoundNBT outputTag, int outputCount) {
            this.identifier = identifier;
            this.output = output;
            this.outputTag = outputTag;
            this.outputCount = outputCount;
            this.serializer = serializer;
        }

        public T group(String group) {
            this.group = group == null || group.trim().isEmpty() ? null : group;
            return this.self();
        }

        public T condition(ICondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T condition(ResourceCondition condition) {
            return this.condition(ResourceCondition.createForgeCondition(condition));
        }

        public T notCondition(ICondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public T advancement(boolean generate) {
            this.hasAdvancement = generate;
            return this.self();
        }

        public T noAdvancement() {
            return this.advancement(false);
        }

        public T unlockedBy(CriterionInstance criterion) {
            if (this.unlockedBy.contains(criterion)) {
                throw new RuntimeException("Duplicate unlockedBy criterion '" + criterion + "'!");
            }
            this.unlockedBy.add(criterion);
            return this.self();
        }

        public T unlockedBy(IItemProvider ... items) {
            return this.unlockedBy((CriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])items));
        }

        public T unlockedBy(ITag<Item> tagKey) {
            return this.unlockedBy((CriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(tagKey).func_200310_b()}));
        }

        public T customSerializer(IRecipeSerializer<?> serializer) {
            this.serializer = serializer;
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }
}

